/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.InterceptFromDefinition;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.RouteConfigurationDefinition;
import org.apache.camel.model.RouteContainer;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteDefinitionHelper;
import org.apache.camel.spi.AsEndpointUri;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.Resource;
import org.apache.camel.support.OrderedComparator;
import org.apache.camel.support.PatternHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(label="configuration")
@XmlRootElement(name="routes")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RoutesDefinition
extends OptionalIdentifiedDefinition<RoutesDefinition>
implements RouteContainer,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(RoutesDefinition.class);
    @XmlElementRef
    private List<RouteDefinition> routes = new ArrayList<RouteDefinition>();
    @XmlTransient
    private List<InterceptDefinition> intercepts = new ArrayList<InterceptDefinition>();
    @XmlTransient
    private List<InterceptFromDefinition> interceptFroms = new ArrayList<InterceptFromDefinition>();
    @XmlTransient
    private List<InterceptSendToEndpointDefinition> interceptSendTos = new ArrayList<InterceptSendToEndpointDefinition>();
    @XmlTransient
    private List<OnExceptionDefinition> onExceptions = new ArrayList<OnExceptionDefinition>();
    @XmlTransient
    private List<OnCompletionDefinition> onCompletions = new ArrayList<OnCompletionDefinition>();
    @XmlTransient
    private CamelContext camelContext;
    @XmlTransient
    private ErrorHandlerFactory errorHandlerFactory;
    @XmlTransient
    private Resource resource;

    public String toString() {
        return "Routes: " + this.routes;
    }

    @Override
    public String getShortName() {
        return "routes";
    }

    @Override
    public String getLabel() {
        return "Route " + this.getId();
    }

    @Override
    public List<RouteDefinition> getRoutes() {
        return this.routes;
    }

    @Override
    public void setRoutes(List<RouteDefinition> routes) {
        this.routes = routes;
    }

    public List<InterceptFromDefinition> getInterceptFroms() {
        return this.interceptFroms;
    }

    public void setInterceptFroms(List<InterceptFromDefinition> interceptFroms) {
        this.interceptFroms = interceptFroms;
    }

    public List<InterceptSendToEndpointDefinition> getInterceptSendTos() {
        return this.interceptSendTos;
    }

    public void setInterceptSendTos(List<InterceptSendToEndpointDefinition> interceptSendTos) {
        this.interceptSendTos = interceptSendTos;
    }

    public List<InterceptDefinition> getIntercepts() {
        return this.intercepts;
    }

    public void setIntercepts(List<InterceptDefinition> intercepts) {
        this.intercepts = intercepts;
    }

    public List<OnExceptionDefinition> getOnExceptions() {
        return this.onExceptions;
    }

    public void setOnExceptions(List<OnExceptionDefinition> onExceptions) {
        this.onExceptions = onExceptions;
    }

    public List<OnCompletionDefinition> getOnCompletions() {
        return this.onCompletions;
    }

    public void setOnCompletions(List<OnCompletionDefinition> onCompletions) {
        this.onCompletions = onCompletions;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public ErrorHandlerFactory getErrorHandlerFactory() {
        return this.errorHandlerFactory;
    }

    public void setErrorHandlerFactory(ErrorHandlerFactory errorHandlerFactory) {
        this.errorHandlerFactory = errorHandlerFactory;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public RouteDefinition route() {
        RouteDefinition route = this.createRoute();
        return this.route(route);
    }

    public RouteDefinition from(@AsEndpointUri String uri) {
        RouteDefinition route = this.createRoute();
        route.from(uri);
        return this.route(route);
    }

    public RouteDefinition from(Endpoint endpoint) {
        RouteDefinition route = this.createRoute();
        route.from(endpoint);
        return this.route(route);
    }

    public RouteDefinition from(EndpointConsumerBuilder endpoint) {
        RouteDefinition route = this.createRoute();
        route.from(endpoint);
        return this.route(route);
    }

    public RouteDefinition route(RouteDefinition route) {
        ErrorHandlerFactory handler = this.getErrorHandlerFactory();
        if (handler != null) {
            route.setErrorHandlerFactoryIfNull(handler);
        }
        this.getRoutes().add(route);
        return route;
    }

    public void prepareRoute(RouteDefinition route) {
        List<RouteConfigurationDefinition> globalConfigurations;
        if (route.isPrepared()) {
            return;
        }
        route.resetPrepare();
        route.setResource(this.resource);
        ArrayList<OnExceptionDefinition> oe = new ArrayList<OnExceptionDefinition>(this.onExceptions);
        ArrayList<InterceptDefinition> icp = new ArrayList<InterceptDefinition>(this.intercepts);
        ArrayList<InterceptFromDefinition> ifrom = new ArrayList<InterceptFromDefinition>(this.interceptFroms);
        ArrayList<InterceptSendToEndpointDefinition> ito = new ArrayList<InterceptSendToEndpointDefinition>(this.interceptSendTos);
        ArrayList<OnCompletionDefinition> oc = new ArrayList<OnCompletionDefinition>(this.onCompletions);
        if (this.getCamelContext() != null && (globalConfigurations = this.getCamelContext().adapt(ModelCamelContext.class).getRouteConfigurationDefinitions()) != null) {
            String[] ids;
            String[] stringArray;
            if (route.getRouteConfigurationId() != null) {
                stringArray = route.getRouteConfigurationId().split(",");
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "*";
            }
            for (String id : ids = stringArray) {
                globalConfigurations.stream().sorted(OrderedComparator.get()).filter(g -> {
                    if (route.getRouteConfigurationId() != null) {
                        return PatternHelper.matchPattern(g.getId(), id);
                    }
                    return g.getId() == null || g.getId().equals(id);
                }).forEach(g -> {
                    String aid = g.getId() == null ? "<default>" : g.getId();
                    route.addAppliedRouteConfigurationId(aid);
                    oe.addAll(g.getOnExceptions());
                    icp.addAll(g.getIntercepts());
                    ifrom.addAll(g.getInterceptFroms());
                    ito.addAll(g.getInterceptSendTos());
                    oc.addAll(g.getOnCompletions());
                });
            }
        }
        RouteDefinitionHelper.prepareRoute(this.getCamelContext(), route, oe, icp, ifrom, ito, oc);
        if (LOG.isDebugEnabled() && route.getAppliedRouteConfigurationIds() != null) {
            LOG.debug("Route: {} is using route configurations ids: {}", (Object)route.getId(), route.getAppliedRouteConfigurationIds());
        }
        route.markPrepared();
    }

    public InterceptDefinition intercept() {
        InterceptDefinition answer = new InterceptDefinition();
        this.getIntercepts().add(0, answer);
        return answer;
    }

    public InterceptFromDefinition interceptFrom() {
        InterceptFromDefinition answer = new InterceptFromDefinition();
        this.getInterceptFroms().add(answer);
        return answer;
    }

    public InterceptFromDefinition interceptFrom(@AsEndpointUri String uri) {
        InterceptFromDefinition answer = new InterceptFromDefinition(uri);
        this.getInterceptFroms().add(answer);
        return answer;
    }

    public InterceptSendToEndpointDefinition interceptSendToEndpoint(@AsEndpointUri String uri) {
        InterceptSendToEndpointDefinition answer = new InterceptSendToEndpointDefinition(uri);
        this.getInterceptSendTos().add(answer);
        return answer;
    }

    public OnExceptionDefinition onException(Class<? extends Throwable> exception) {
        OnExceptionDefinition answer = new OnExceptionDefinition(exception);
        answer.setRouteScoped(false);
        this.getOnExceptions().add(answer);
        return answer;
    }

    public OnCompletionDefinition onCompletion() {
        OnCompletionDefinition answer = new OnCompletionDefinition();
        answer.setRouteScoped(false);
        this.getOnCompletions().add(answer);
        return answer;
    }

    protected RouteDefinition createRoute() {
        RouteDefinition route = new RouteDefinition();
        ErrorHandlerFactory handler = this.getErrorHandlerFactory();
        if (handler != null) {
            route.setErrorHandlerFactoryIfNull(handler);
        }
        return route;
    }
}

