/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.spi.AsEndpointUri;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing")
@XmlRootElement(name="toD")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ToDynamicDefinition
extends NoOutputDefinition<ToDynamicDefinition> {
    @XmlTransient
    protected EndpointProducerBuilder endpointProducerBuilder;
    @XmlAttribute
    @Metadata(required=true)
    private String uri;
    @XmlAttribute
    @Metadata(javaType="org.apache.camel.ExchangePattern", enums="InOnly,InOut,InOptionalOut")
    private String pattern;
    @XmlAttribute
    @Metadata(javaType="java.lang.Integer")
    private String cacheSize;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String ignoreInvalidEndpoint;
    @XmlAttribute
    @Metadata(label="advanced", defaultValue="true", javaType="java.lang.Boolean")
    private String allowOptimisedComponents;
    @XmlAttribute
    @Metadata(label="advanced", defaultValue="true", javaType="java.lang.Boolean")
    private String autoStartComponents;

    public ToDynamicDefinition() {
    }

    public ToDynamicDefinition(String uri) {
        this.uri = uri;
    }

    @Override
    public String getShortName() {
        return "toD";
    }

    public String toString() {
        return "DynamicTo[" + this.getLabel() + "]";
    }

    @Override
    public String getLabel() {
        return this.uri;
    }

    public ToDynamicDefinition uri(@AsEndpointUri String uri) {
        this.setUri(uri);
        return this;
    }

    public ToDynamicDefinition uri(@AsEndpointUri EndpointProducerBuilder endpointProducerBuilder) {
        this.setEndpointProducerBuilder(endpointProducerBuilder);
        return this;
    }

    public ToDynamicDefinition pattern(ExchangePattern pattern) {
        return this.pattern(pattern.name());
    }

    public ToDynamicDefinition pattern(String pattern) {
        this.setPattern(pattern);
        return this;
    }

    public ToDynamicDefinition cacheSize(int cacheSize) {
        return this.cacheSize(Integer.toString(cacheSize));
    }

    public ToDynamicDefinition cacheSize(String cacheSize) {
        this.setCacheSize(cacheSize);
        return this;
    }

    public ToDynamicDefinition ignoreInvalidEndpoint(boolean ignoreInvalidEndpoint) {
        return this.ignoreInvalidEndpoint(Boolean.toString(ignoreInvalidEndpoint));
    }

    public ToDynamicDefinition ignoreInvalidEndpoint(String ignoreInvalidEndpoint) {
        this.setIgnoreInvalidEndpoint(ignoreInvalidEndpoint);
        return this;
    }

    public ToDynamicDefinition allowOptimisedComponents(boolean allowOptimisedComponents) {
        return this.allowOptimisedComponents(Boolean.toString(allowOptimisedComponents));
    }

    public ToDynamicDefinition allowOptimisedComponents(String allowOptimisedComponents) {
        this.setAllowOptimisedComponents(allowOptimisedComponents);
        return this;
    }

    public ToDynamicDefinition autoStartComponents(String autoStartComponents) {
        this.setAutoStartComponents(autoStartComponents);
        return this;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public EndpointProducerBuilder getEndpointProducerBuilder() {
        return this.endpointProducerBuilder;
    }

    public void setEndpointProducerBuilder(EndpointProducerBuilder endpointProducerBuilder) {
        this.endpointProducerBuilder = endpointProducerBuilder;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(String cacheSize) {
        this.cacheSize = cacheSize;
    }

    public String getIgnoreInvalidEndpoint() {
        return this.ignoreInvalidEndpoint;
    }

    public void setIgnoreInvalidEndpoint(String ignoreInvalidEndpoint) {
        this.ignoreInvalidEndpoint = ignoreInvalidEndpoint;
    }

    public String getAllowOptimisedComponents() {
        return this.allowOptimisedComponents;
    }

    public void setAllowOptimisedComponents(String allowOptimisedComponents) {
        this.allowOptimisedComponents = allowOptimisedComponents;
    }

    public String getAutoStartComponents() {
        return this.autoStartComponents;
    }

    public void setAutoStartComponents(String autoStartComponents) {
        this.autoStartComponents = autoStartComponents;
    }
}

