/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.openapi;

import io.apicurio.datamodels.core.models.common.Info;
import io.apicurio.datamodels.core.models.common.Server;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import java.util.ArrayList;
import java.util.Arrays;

public class BeanConfig {
    String[] schemes;
    String title;
    String version;
    String licenseUrl;
    String license;
    Info info;
    String host;
    String basePath;

    public String[] getSchemes() {
        return this.schemes;
    }

    public void setSchemes(String[] schemes) {
        this.schemes = schemes;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public Info getInfo() {
        return this.info;
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        if (!"".equals(basePath) && basePath != null) {
            this.basePath = !basePath.startsWith("/") ? "/" + basePath : basePath;
        }
    }

    public OasDocument configure(OasDocument openApi) {
        if (openApi instanceof Oas20Document) {
            this.configureOas20((Oas20Document)openApi);
        } else if (openApi instanceof Oas30Document) {
            this.configureOas30((Oas30Document)openApi);
        }
        return openApi;
    }

    private void configureOas30(Oas30Document openApi) {
        if (this.info != null) {
            openApi.info = this.info;
            this.info._ownerDocument = openApi;
            this.info._parent = openApi;
        }
        Server server = openApi.createServer();
        server.url = this.schemes[0] + "://" + this.host + this.basePath;
        openApi.addServer(server);
    }

    private void configureOas20(Oas20Document openApi) {
        if (this.schemes != null) {
            if (openApi.schemes == null) {
                openApi.schemes = new ArrayList<String>();
            }
            openApi.schemes.addAll(Arrays.asList(this.schemes));
        }
        if (this.info != null) {
            openApi.info = this.info;
            this.info._ownerDocument = openApi;
            this.info._parent = openApi;
        }
        openApi.host = this.host;
        openApi.basePath = this.basePath;
    }

    public boolean isOpenApi3() {
        return this.version == null || this.version.startsWith("3");
    }
}

