/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.openapi;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.openapi.RestOpenApiProcessor;
import org.apache.camel.spi.RestApiProcessorFactory;
import org.apache.camel.spi.RestConfiguration;

public class OpenApiRestApiProcessorFactory
implements RestApiProcessorFactory {
    @Override
    public Processor createApiProcessor(CamelContext camelContext, String contextPath, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        Object cors;
        String path;
        String scheme;
        String host;
        HashMap<String, Object> options = new HashMap<String, Object>(parameters);
        if (configuration.getApiProperties() != null) {
            options.putAll(configuration.getApiProperties());
        }
        if ((host = (String)options.get("host")) != null) {
            options.put("host", host);
        } else {
            host = configuration.getApiHost();
            if (host != null) {
                options.put("host", host);
            } else {
                host = configuration.getHost();
                int port = configuration.getPort();
                if (host != null && port > 0) {
                    options.put("host", host + ":" + port);
                } else if (host != null) {
                    options.put("host", host);
                } else {
                    options.put("host", "localhost");
                }
            }
        }
        if (!options.containsKey("schemes") && !options.containsKey("schemas") && (scheme = configuration.getScheme()) != null) {
            options.put("schemes", scheme);
        }
        if ((path = configuration.getContextPath()) != null) {
            options.put("base.path", path);
        }
        if ((cors = options.get("cors")) == null && configuration.isEnableCORS()) {
            options.put("cors", "true");
        }
        return new RestOpenApiProcessor(options, configuration);
    }
}

