/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.List;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.processor.InterceptEndpointProcessor;
import org.apache.camel.processor.InterceptSendToEndpointCallback;
import org.apache.camel.reifier.ProcessorReifier;

public class InterceptSendToEndpointReifier
extends ProcessorReifier<InterceptSendToEndpointDefinition> {
    public InterceptSendToEndpointReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (InterceptSendToEndpointDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        Processor before = this.createChildProcessor(true);
        Processor afterProcessor = null;
        String afterUri = this.parseString(((InterceptSendToEndpointDefinition)this.definition).getAfterUri());
        if (afterUri != null) {
            ToDefinition to = new ToDefinition(afterUri);
            afterProcessor = this.camelContext.adapt(ExtendedCamelContext.class).getProcessorFactory().createProcessor(this.route, to);
            if (afterProcessor == null) {
                afterProcessor = this.createProcessor(to);
            }
        }
        Processor after = afterProcessor;
        String matchURI = this.parseString(((InterceptSendToEndpointDefinition)this.definition).getUri());
        boolean skip = this.parseBoolean(((InterceptSendToEndpointDefinition)this.definition).getSkipSendToOriginalEndpoint(), false);
        this.camelContext.adapt(ExtendedCamelContext.class).registerEndpointCallback(new InterceptSendToEndpointCallback(this.camelContext, before, after, matchURI, skip));
        RouteDefinition route = (RouteDefinition)this.route.getRoute();
        List<ProcessorDefinition<?>> outputs = route.getOutputs();
        outputs.remove(this.definition);
        return new InterceptEndpointProcessor(matchURI, before);
    }
}

