/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.RouteTemplateLoaderListener;
import org.apache.camel.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RouteTemplateHelper {
    private static final Logger LOG = LoggerFactory.getLogger(RouteTemplateHelper.class);

    private RouteTemplateHelper() {
    }

    public static void loadRouteTemplateFromLocation(CamelContext camelContext, RouteTemplateLoaderListener listener, String templateId, String location) throws Exception {
        if (location == null) {
            throw new IllegalArgumentException("Location is empty");
        }
        ExtendedCamelContext ecc = camelContext.adapt(ExtendedCamelContext.class);
        boolean found = false;
        String[] stringArray = location.split(",");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String path;
            String name = path = stringArray[i];
            Resource res = null;
            String ext = FileUtil.onlyExt(path);
            if (ext != null) {
                res = ecc.getResourceLoader().resolveResource(name);
            }
            if (res == null || !res.exists()) {
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                name = path + templateId + ".kamelet.yaml";
                res = ecc.getResourceLoader().resolveResource(name);
            }
            if (!res.exists()) continue;
            try {
                if (listener != null) {
                    listener.loadRouteTemplate(res);
                }
            }
            catch (Exception e) {
                LOG.warn("RouteTemplateLoaderListener error due to " + e.getMessage() + ". This exception is ignored", (Throwable)e);
            }
            ecc.getRoutesLoader().loadRoutes(res);
            found = true;
            break;
        }
        if (!found) {
            String path = location;
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            String target = path + templateId + ".kamelet.yaml";
            ecc.getRoutesLoader().loadRoutes(ecc.getResourceLoader().resolveResource(target));
        }
    }
}

