/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.cluster;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Consumer;
import org.apache.camel.CamelContext;
import org.apache.camel.cluster.CamelClusterEventListener;
import org.apache.camel.cluster.CamelClusterMember;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.cluster.CamelClusterView;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.concurrent.LockHelper;

public abstract class AbstractCamelClusterView
extends ServiceSupport
implements CamelClusterView {
    private final CamelClusterService clusterService;
    private final String namespace;
    private final List<CamelClusterEventListener> listeners;
    private final StampedLock lock;
    private CamelContext camelContext;

    protected AbstractCamelClusterView(CamelClusterService cluster, String namespace) {
        this.clusterService = cluster;
        this.namespace = namespace;
        this.listeners = new ArrayList<CamelClusterEventListener>();
        this.lock = new StampedLock();
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public CamelClusterService getClusterService() {
        return this.clusterService;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void addEventListener(CamelClusterEventListener listener) {
        if (listener == null) {
            return;
        }
        LockHelper.doWithWriteLock(this.lock, () -> {
            this.listeners.add(listener);
            if (this.isRunAllowed()) {
                if (CamelClusterEventListener.Leadership.class.isInstance(listener)) {
                    ((CamelClusterEventListener.Leadership)CamelClusterEventListener.Leadership.class.cast(listener)).leadershipChanged(this, this.getLeader());
                }
                if (CamelClusterEventListener.Membership.class.isInstance(listener)) {
                    CamelClusterEventListener.Membership ml = (CamelClusterEventListener.Membership)CamelClusterEventListener.Membership.class.cast(listener);
                    for (CamelClusterMember member : this.getMembers()) {
                        ml.memberAdded(this, member);
                    }
                }
            }
        });
    }

    @Override
    public void removeEventListener(CamelClusterEventListener listener) {
        if (listener == null) {
            return;
        }
        LockHelper.doWithWriteLock(this.lock, () -> this.listeners.removeIf(l -> l == listener));
    }

    private <T extends CamelClusterEventListener> void doWithListener(Class<T> type, Consumer<T> consumer) {
        LockHelper.doWithReadLock(this.lock, () -> {
            for (int i = 0; i < this.listeners.size(); ++i) {
                CamelClusterEventListener listener = this.listeners.get(i);
                if (!type.isInstance(listener)) continue;
                consumer.accept(type.cast(listener));
            }
        });
    }

    protected void fireLeadershipChangedEvent(Optional<CamelClusterMember> leader) {
        this.doWithListener(CamelClusterEventListener.Leadership.class, listener -> listener.leadershipChanged(this, leader));
    }

    protected void fireMemberAddedEvent(CamelClusterMember member) {
        this.doWithListener(CamelClusterEventListener.Membership.class, listener -> listener.memberAdded(this, member));
    }

    protected void fireMemberRemovedEvent(CamelClusterMember member) {
        this.doWithListener(CamelClusterEventListener.Membership.class, listener -> listener.memberRemoved(this, member));
    }
}

