/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.throttling;

import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.support.RoutePolicySupport;
import org.apache.camel.throttling.ThrottlingExceptionHalfOpenHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottlingExceptionRoutePolicy
extends RoutePolicySupport
implements CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(ThrottlingExceptionRoutePolicy.class);
    private static final int STATE_CLOSED = 0;
    private static final int STATE_HALF_OPEN = 1;
    private static final int STATE_OPEN = 2;
    private CamelContext camelContext;
    private final Lock lock = new ReentrantLock();
    private int failureThreshold;
    private long failureWindow;
    private long halfOpenAfter;
    private final List<Class<?>> throttledExceptions;
    private ThrottlingExceptionHalfOpenHandler halfOpenHandler;
    private final AtomicInteger failures = new AtomicInteger();
    private final AtomicInteger state = new AtomicInteger(0);
    private final AtomicBoolean keepOpen = new AtomicBoolean();
    private volatile Timer halfOpenTimer;
    private volatile long lastFailure;
    private volatile long openedAt;

    public ThrottlingExceptionRoutePolicy(int threshold, long failureWindow, long halfOpenAfter, List<Class<?>> handledExceptions) {
        this(threshold, failureWindow, halfOpenAfter, handledExceptions, false);
    }

    public ThrottlingExceptionRoutePolicy(int threshold, long failureWindow, long halfOpenAfter, List<Class<?>> handledExceptions, boolean keepOpen) {
        this.throttledExceptions = handledExceptions;
        this.failureWindow = failureWindow;
        this.halfOpenAfter = halfOpenAfter;
        this.failureThreshold = threshold;
        this.keepOpen.set(keepOpen);
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void onInit(Route route) {
        LOG.debug("Initializing ThrottlingExceptionRoutePolicy route policy");
        this.logState();
    }

    @Override
    public void onStart(Route route) {
        if (this.keepOpen.get()) {
            this.openCircuit(route);
        }
    }

    @Override
    public void onExchangeDone(Route route, Exchange exchange) {
        if (this.keepOpen.get()) {
            if (this.state.get() != 2) {
                LOG.debug("opening circuit b/c keepOpen is on");
                this.openCircuit(route);
            }
        } else {
            if (this.hasFailed(exchange)) {
                this.failures.incrementAndGet();
                this.lastFailure = System.currentTimeMillis();
            }
            this.calculateState(route);
        }
    }

    private boolean hasFailed(Exchange exchange) {
        if (exchange == null) {
            return false;
        }
        boolean answer = false;
        if (exchange.getException() != null) {
            if (this.throttledExceptions == null || this.throttledExceptions.isEmpty()) {
                answer = true;
            } else {
                for (Class<?> exception : this.throttledExceptions) {
                    if (exchange.getException(exception) == null) continue;
                    answer = true;
                    break;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            String exceptionName = exchange.getException() == null ? "none" : exchange.getException().getClass().getSimpleName();
            LOG.debug("hasFailed ({}) with Throttled Exception: {} for exchangeId: {}", new Object[]{answer, exceptionName, exchange.getExchangeId()});
        }
        return answer;
    }

    private void calculateState(Route route) {
        boolean failureLimitReached = this.isThresholdExceeded();
        if (this.state.get() == 0) {
            if (failureLimitReached) {
                LOG.debug("Opening circuit...");
                this.openCircuit(route);
            }
        } else if (this.state.get() == 1) {
            if (failureLimitReached) {
                LOG.debug("Opening circuit...");
                this.openCircuit(route);
            } else {
                LOG.debug("Closing circuit...");
                this.closeCircuit(route);
            }
        } else if (this.state.get() == 2) {
            if (!this.keepOpen.get()) {
                long elapsedTimeSinceOpened = System.currentTimeMillis() - this.openedAt;
                if (this.halfOpenAfter <= elapsedTimeSinceOpened) {
                    LOG.debug("Checking an open circuit...");
                    if (this.halfOpenHandler != null) {
                        if (this.halfOpenHandler.isReadyToBeClosed()) {
                            LOG.debug("Closing circuit...");
                            this.closeCircuit(route);
                        } else {
                            LOG.debug("Opening circuit...");
                            this.openCircuit(route);
                        }
                    } else {
                        LOG.debug("Half opening circuit...");
                        this.halfOpenCircuit(route);
                    }
                } else {
                    LOG.debug("keeping circuit open (time not elapsed)...");
                }
            } else {
                LOG.debug("keeping circuit open (keepOpen is true)...");
                this.addHalfOpenTimer(route);
            }
        }
    }

    protected boolean isThresholdExceeded() {
        boolean output = false;
        this.logState();
        if (this.failures.get() >= this.failureThreshold && this.lastFailure >= System.currentTimeMillis() - this.failureWindow) {
            output = true;
        }
        return output;
    }

    protected void openCircuit(Route route) {
        try {
            this.lock.lock();
            this.suspendOrStopConsumer(route.getConsumer());
            this.state.set(2);
            this.openedAt = System.currentTimeMillis();
            this.addHalfOpenTimer(route);
            this.logState();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void addHalfOpenTimer(Route route) {
        this.halfOpenTimer = new Timer();
        this.halfOpenTimer.schedule((TimerTask)new HalfOpenTask(route), this.halfOpenAfter);
    }

    protected void halfOpenCircuit(Route route) {
        try {
            this.lock.lock();
            this.resumeOrStartConsumer(route.getConsumer());
            this.state.set(1);
            this.logState();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void closeCircuit(Route route) {
        try {
            this.lock.lock();
            this.resumeOrStartConsumer(route.getConsumer());
            this.failures.set(0);
            this.lastFailure = 0L;
            this.openedAt = 0L;
            this.state.set(0);
            this.logState();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void logState() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.dumpState());
        }
    }

    public String dumpState() {
        int num = this.state.get();
        String routeState = ThrottlingExceptionRoutePolicy.stateAsString(num);
        if (this.failures.get() > 0) {
            return String.format("State %s, failures %d, last failure %d ms ago", routeState, this.failures.get(), System.currentTimeMillis() - this.lastFailure);
        }
        return String.format("State %s, failures %d", routeState, this.failures.get());
    }

    private static String stateAsString(int num) {
        if (num == 0) {
            return "closed";
        }
        if (num == 1) {
            return "half opened";
        }
        return "opened";
    }

    public ThrottlingExceptionHalfOpenHandler getHalfOpenHandler() {
        return this.halfOpenHandler;
    }

    public void setHalfOpenHandler(ThrottlingExceptionHalfOpenHandler halfOpenHandler) {
        this.halfOpenHandler = halfOpenHandler;
    }

    public boolean getKeepOpen() {
        return this.keepOpen.get();
    }

    public void setKeepOpen(boolean keepOpen) {
        LOG.debug("keep open: {}", (Object)keepOpen);
        this.keepOpen.set(keepOpen);
    }

    public int getFailureThreshold() {
        return this.failureThreshold;
    }

    public void setFailureThreshold(int failureThreshold) {
        this.failureThreshold = failureThreshold;
    }

    public long getFailureWindow() {
        return this.failureWindow;
    }

    public void setFailureWindow(long failureWindow) {
        this.failureWindow = failureWindow;
    }

    public long getHalfOpenAfter() {
        return this.halfOpenAfter;
    }

    public void setHalfOpenAfter(long halfOpenAfter) {
        this.halfOpenAfter = halfOpenAfter;
    }

    public int getFailures() {
        return this.failures.get();
    }

    public long getLastFailure() {
        return this.lastFailure;
    }

    public long getOpenedAt() {
        return this.openedAt;
    }

    class HalfOpenTask
    extends TimerTask {
        private final Route route;

        HalfOpenTask(Route route) {
            this.route = route;
        }

        @Override
        public void run() {
            ThrottlingExceptionRoutePolicy.this.halfOpenTimer.cancel();
            ThrottlingExceptionRoutePolicy.this.calculateState(this.route);
        }
    }
}

