/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.client;

import com.openshift.client.OpenShiftException;
import com.openshift.internal.client.ssh.AbstractSSHKey;
import com.openshift.internal.client.utils.StreamUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SSHPublicKey
extends AbstractSSHKey {
    private static final Pattern PUBLICKEY_PATTERN = Pattern.compile("([^ ]+) ([^ ]+)( .+)*");
    private String publicKey;

    public SSHPublicKey(String publicKeyFilePath) throws FileNotFoundException, OpenShiftException, IOException {
        this(new File(publicKeyFilePath));
    }

    public SSHPublicKey(File publicKeyFile) throws FileNotFoundException, OpenShiftException, IOException {
        super(null);
        this.init(publicKeyFile);
    }

    @Override
    public String getPublicKey() {
        return this.publicKey;
    }

    private void init(File publicKeyFile) throws OpenShiftException, FileNotFoundException, IOException {
        String keyWithIdAndComment = StreamUtils.readToString(new FileReader(publicKeyFile));
        Matcher matcher = PUBLICKEY_PATTERN.matcher(keyWithIdAndComment);
        if (!matcher.find() || matcher.groupCount() < 1) {
            throw new OpenShiftException("Could not load public key from file \"{0}\": unknown key format.", publicKeyFile.getAbsolutePath());
        }
        this.setKeyType(matcher.group(1));
        this.publicKey = matcher.group(2);
    }
}

