/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.client.cartridge.query;

import com.openshift.client.cartridge.ICartridge;
import com.openshift.client.cartridge.query.AbstractCartridgeQuery;
import com.openshift.internal.client.utils.Assert;
import java.util.regex.Pattern;

public abstract class StringPropertyQuery
extends AbstractCartridgeQuery {
    private final Pattern namePattern;

    public StringPropertyQuery(String propertyPattern) {
        Assert.isTrue(propertyPattern != null);
        this.namePattern = Pattern.compile(propertyPattern);
    }

    public StringPropertyQuery(Pattern pattern) {
        Assert.isTrue(pattern != null);
        this.namePattern = pattern;
    }

    @Override
    public <C extends ICartridge> boolean matches(C cartridge) {
        if (cartridge == null) {
            return false;
        }
        String propertyValue = this.getProperty(cartridge);
        if (propertyValue == null) {
            return this.namePattern == null;
        }
        return this.namePattern.matcher(propertyValue).matches();
    }

    protected abstract <C extends ICartridge> String getProperty(C var1);
}

