/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.client.utils;

import com.openshift.internal.client.utils.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

public class TarFileUtils {
    private static final String GIT_FOLDER_NAME = "git";

    private TarFileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasGitFolder(InputStream inputStream) throws IOException {
        boolean bl;
        TarArchiveInputStream tarInputStream = null;
        try {
            boolean gitFolderPresent = false;
            tarInputStream = new TarArchiveInputStream(new GzipCompressorInputStream(inputStream));
            TarArchiveEntry entry = null;
            while ((entry = tarInputStream.getNextTarEntry()) != null) {
                if (!GIT_FOLDER_NAME.equals(entry.getName()) || !entry.isDirectory()) continue;
                gitFolderPresent = true;
                break;
            }
            bl = gitFolderPresent;
        }
        catch (Throwable throwable) {
            StreamUtils.close(tarInputStream);
            throw throwable;
        }
        StreamUtils.close(tarInputStream);
        return bl;
    }
}

