/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client;

import com.openshift.client.IGearGroup;
import com.openshift.client.Messages;
import com.openshift.client.OpenShiftException;
import com.openshift.client.cartridge.IDeployedStandaloneCartridge;
import com.openshift.client.cartridge.IStandaloneCartridge;
import com.openshift.internal.client.AbstractOpenShiftResource;
import com.openshift.internal.client.ApplicationResource;
import com.openshift.internal.client.CartridgeType;
import com.openshift.internal.client.IRestService;
import com.openshift.internal.client.httpclient.request.Parameter;
import com.openshift.internal.client.response.CartridgeResourceDTO;
import com.openshift.internal.client.response.Link;
import com.openshift.internal.client.utils.Assert;
import java.net.URL;
import java.util.Map;

public class StandaloneCartridgeResource
extends AbstractOpenShiftResource
implements IStandaloneCartridge,
IDeployedStandaloneCartridge {
    private static final String LINK_UPDATE_CARTRIDGE = "UPDATE";
    private ApplicationResource application;
    private String name;
    private String displayName;
    private String description;
    private URL url;
    private CartridgeType cartridgeType;
    private boolean obsolete;

    protected StandaloneCartridgeResource(CartridgeResourceDTO dto, ApplicationResource application) {
        this(dto.getName(), dto.getDisplayName(), dto.getDescription(), dto.getUrl(), dto.getType(), dto.getObsolete(), application, application.getService(), dto.getLinks(), dto.getMessages());
    }

    protected StandaloneCartridgeResource(String name, String displayName, String description, URL url, CartridgeType cartridgeType, boolean obsolete, ApplicationResource application, IRestService service, Map<String, Link> links, Messages messages) {
        super(service, links, messages);
        Assert.isTrue(cartridgeType != null && cartridgeType.equals((Object)CartridgeType.STANDALONE));
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.url = url;
        this.cartridgeType = cartridgeType;
        this.obsolete = obsolete;
        this.application = application;
    }

    @Override
    public void setAdditionalGearStorage(int size) {
        new UpdateCartridgeRequest().execute(new Parameter("additional_gear_storage", String.valueOf(size)));
    }

    @Override
    public int getAdditionalGearStorage() {
        IGearGroup gearGroup = this.getGearGroup();
        if (gearGroup == null) {
            return -1;
        }
        return gearGroup.getAdditionalStorage();
    }

    @Override
    public IGearGroup getGearGroup() {
        return this.application.getGearGroup(this);
    }

    @Override
    public void refresh() throws OpenShiftException {
        this.application.refreshEmbeddedCartridges();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isDownloadable() {
        return this.url != null;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public CartridgeType getType() {
        return this.cartridgeType;
    }

    public boolean equals(Object obj) {
        if (!IDeployedStandaloneCartridge.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        IDeployedStandaloneCartridge otherCartridge = (IDeployedStandaloneCartridge)obj;
        return !(this.getName() == null ? otherCartridge.getName() != null : !this.getName().equals(otherCartridge.getName()));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean isObsolete() {
        return this.obsolete;
    }

    public String toString() {
        return "StandaloneCartridgeResource [application=" + this.application + ", name=" + this.name + ", displayName=" + this.displayName + ", description=" + this.description + ", url=" + this.url + ", cartridgeType=" + (Object)((Object)this.cartridgeType) + ", obsolete=" + this.obsolete + "]";
    }

    private class UpdateCartridgeRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        private UpdateCartridgeRequest() {
            super(StandaloneCartridgeResource.this, StandaloneCartridgeResource.LINK_UPDATE_CARTRIDGE);
        }
    }
}

