/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client.httpclient;

import com.openshift.internal.client.utils.Assert;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;

public class CallbackTrustManager
implements X509TrustManager {
    private X509TrustManager trustManager;
    private TrustManagerCallback callback;

    private CallbackTrustManager(X509TrustManager trustManager, TrustManagerCallback callback) {
        Assert.isTrue(trustManager != null);
        this.trustManager = trustManager;
        this.callback = callback;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        block2: {
            try {
                this.trustManager.checkServerTrusted(chain, authType);
            }
            catch (CertificateException e) {
                if (!this.callback.allow(chain)) break block2;
                throw e;
            }
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.trustManager.checkServerTrusted(chain, authType);
    }

    public static interface TrustManagerCallback {
        public boolean allow(X509Certificate[] var1);
    }
}

