/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openshift;

import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.openshift.OpenShiftEndpoint;
import org.apache.camel.component.openshift.OpenShiftHelper;
import org.apache.camel.impl.ScheduledPollConsumer;

public class OpenShiftConsumer
extends ScheduledPollConsumer {
    private static final long INITIAL_DELAY = 1000L;
    private static final long DELAY = 10000L;
    private final Map<ApplicationState, ApplicationState> oldState = new HashMap<ApplicationState, ApplicationState>();
    private volatile boolean initialPoll;

    public OpenShiftConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.setInitialDelay(1000L);
        this.setDelay(10000L);
    }

    public OpenShiftEndpoint getEndpoint() {
        return (OpenShiftEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        this.initialPoll = true;
        super.doStart();
    }

    protected int poll() throws Exception {
        String openshiftServer = OpenShiftHelper.getOpenShiftServer(this.getEndpoint());
        IDomain domain = OpenShiftHelper.loginAndGetDomain(this.getEndpoint(), openshiftServer);
        if (domain == null) {
            return 0;
        }
        return this.doPollOnChange(domain);
    }

    protected int doPollAll(IDomain domain) {
        List<IApplication> apps = domain.getApplications();
        for (IApplication app : apps) {
            Exchange exchange = this.getEndpoint().createExchange(app);
            try {
                this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
            }
            if (exchange.getException() == null) continue;
            this.getExceptionHandler().handleException("Error during processing exchange.", exchange, (Throwable)exchange.getException());
        }
        return apps.size();
    }

    protected int doPollOnChange(IDomain domain) {
        HashMap<ApplicationState, ApplicationState> newState = new HashMap<ApplicationState, ApplicationState>();
        List<IApplication> apps = domain.getApplications();
        for (IApplication app : apps) {
            ApplicationState state = new ApplicationState(app.getUUID(), app, OpenShiftHelper.getStateForApplication(app));
            newState.put(state, state);
        }
        HashMap<ApplicationState, ApplicationState> added = new HashMap<ApplicationState, ApplicationState>();
        HashMap<ApplicationState, ApplicationState> removed = new HashMap<ApplicationState, ApplicationState>();
        HashMap<ApplicationState, ApplicationState> changed = new HashMap<ApplicationState, ApplicationState>();
        for (ApplicationState state : newState.keySet()) {
            if (!this.oldState.containsKey(state)) {
                added.put(state, state);
                continue;
            }
            ApplicationState old = this.oldState.get(state);
            if (old == null || old.getState().equals(state.getState())) continue;
            state.setOldState(old.getState());
            changed.put(state, state);
        }
        for (ApplicationState state : this.oldState.keySet()) {
            if (newState.containsKey(state)) continue;
            removed.put(state, state);
        }
        int processed = 0;
        if (!this.initialPoll) {
            Exchange exchange;
            for (ApplicationState add : added.keySet()) {
                exchange = this.getEndpoint().createExchange(add.getApplication());
                exchange.getIn().setHeader("CamelOpenShiftEventType", (Object)"added");
                try {
                    ++processed;
                    this.getProcessor().process(exchange);
                }
                catch (Exception e) {
                    exchange.setException((Throwable)e);
                }
                if (exchange.getException() == null) continue;
                this.getExceptionHandler().handleException("Error during processing exchange.", exchange, (Throwable)exchange.getException());
            }
            for (ApplicationState remove : removed.keySet()) {
                exchange = this.getEndpoint().createExchange(remove.getApplication());
                exchange.getIn().setHeader("CamelOpenShiftEventType", (Object)"removed");
                try {
                    ++processed;
                    this.getProcessor().process(exchange);
                }
                catch (Exception e) {
                    exchange.setException((Throwable)e);
                }
                if (exchange.getException() == null) continue;
                this.getExceptionHandler().handleException("Error during processing exchange.", exchange, (Throwable)exchange.getException());
            }
            for (ApplicationState change : changed.keySet()) {
                exchange = this.getEndpoint().createExchange(change.getApplication());
                exchange.getIn().setHeader("CamelOpenShiftEventType", (Object)"changed");
                exchange.getIn().setHeader("CamelOpenShiftEventOldState", (Object)change.getOldState());
                exchange.getIn().setHeader("CamelOpenShiftEventNewState", (Object)change.getState());
                try {
                    ++processed;
                    this.getProcessor().process(exchange);
                }
                catch (Exception e) {
                    exchange.setException((Throwable)e);
                }
                if (exchange.getException() == null) continue;
                this.getExceptionHandler().handleException("Error during processing exchange.", exchange, (Throwable)exchange.getException());
            }
        }
        this.oldState.clear();
        this.oldState.putAll(newState);
        this.initialPoll = false;
        return processed;
    }

    private static final class ApplicationState {
        private final String uuid;
        private final IApplication application;
        private final String state;
        private String oldState;

        private ApplicationState(String uuid, IApplication application, String state) {
            this.uuid = uuid;
            this.application = application;
            this.state = state;
        }

        public String getUuid() {
            return this.uuid;
        }

        public IApplication getApplication() {
            return this.application;
        }

        public String getState() {
            return this.state;
        }

        public String getOldState() {
            return this.oldState;
        }

        public void setOldState(String oldState) {
            this.oldState = oldState;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ApplicationState that = (ApplicationState)o;
            if (!this.state.equals(that.state)) {
                return false;
            }
            return this.uuid.equals(that.uuid);
        }

        public int hashCode() {
            int result = this.uuid.hashCode();
            result = 31 * result + this.state.hashCode();
            return result;
        }
    }
}

