/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openstack.nova.producer;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.openstack.common.AbstractOpenstackProducer;
import org.apache.camel.component.openstack.nova.NovaEndpoint;
import org.apache.camel.util.StringHelper;
import org.openstack4j.api.OSClient;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.compute.Keypair;

public class KeypairProducer
extends AbstractOpenstackProducer {
    public KeypairProducer(NovaEndpoint endpoint, OSClient client) {
        super(endpoint, client);
    }

    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = this.getOperation(exchange)) {
            case "create": {
                this.doCreate(exchange);
                break;
            }
            case "get": {
                this.doGet(exchange);
                break;
            }
            case "getAll": {
                this.doGetAll(exchange);
                break;
            }
            case "delete": {
                this.doDelete(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    private void doCreate(Exchange exchange) {
        Message msg = exchange.getIn();
        String name = (String)msg.getHeader("name", String.class);
        StringHelper.notEmpty((String)name, (String)"Keypair name");
        String body = (String)msg.getBody(String.class);
        Keypair kp = this.os.compute().keypairs().create(name, body);
        msg.setBody((Object)kp);
    }

    private void doGet(Exchange exchange) {
        Message msg = exchange.getIn();
        String keypairName = (String)msg.getHeader("name", String.class);
        StringHelper.notEmpty((String)keypairName, (String)"Keypair name");
        Keypair kp = this.os.compute().keypairs().get(keypairName);
        msg.setBody((Object)kp);
    }

    private void doGetAll(Exchange exchange) {
        Message msg = exchange.getIn();
        List<? extends Keypair> keypairs = this.os.compute().keypairs().list();
        msg.setBody(keypairs);
    }

    private void doDelete(Exchange exchange) {
        Message msg = exchange.getIn();
        String keypairName = (String)msg.getHeader("name", String.class);
        StringHelper.notEmpty((String)keypairName, (String)"Keypair name");
        ActionResponse response = this.os.compute().keypairs().delete(keypairName);
        this.checkFailure(response, msg, "Delete keypair " + keypairName);
    }
}

