/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.connectors.okhttp;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.Util;
import org.openstack4j.core.transport.Config;
import org.openstack4j.core.transport.HttpMethod;
import org.openstack4j.core.transport.HttpRequest;
import org.openstack4j.core.transport.ObjectMapperSingleton;
import org.openstack4j.core.transport.UntrustedSSL;
import org.openstack4j.core.transport.functions.EndpointURIFromRequestFunction;
import org.openstack4j.core.transport.internal.HttpLoggingFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpCommand<R> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpCommand.class);
    private HttpRequest<R> request;
    private OkHttpClient client;
    private Request.Builder clientReq;
    private int retries;

    private HttpCommand(HttpRequest<R> request) {
        this.request = request;
    }

    public static <R> HttpCommand<R> create(HttpRequest<R> request) {
        HttpCommand<R> command = new HttpCommand<R>(request);
        super.initialize();
        return command;
    }

    private void initialize() {
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder();
        Config config = this.request.getConfig();
        if (config.getProxy() != null) {
            okHttpClientBuilder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(config.getProxy().getRawHost(), config.getProxy().getPort())));
        }
        if (config.getConnectTimeout() > 0) {
            okHttpClientBuilder.connectTimeout(config.getConnectTimeout(), TimeUnit.MILLISECONDS);
        }
        if (config.getReadTimeout() > 0) {
            okHttpClientBuilder.readTimeout(config.getReadTimeout(), TimeUnit.MILLISECONDS);
        }
        if (config.isIgnoreSSLVerification()) {
            okHttpClientBuilder.hostnameVerifier(UntrustedSSL.getHostnameVerifier());
            okHttpClientBuilder.sslSocketFactory(UntrustedSSL.getSSLContext().getSocketFactory());
        }
        if (config.getSslContext() != null) {
            okHttpClientBuilder.sslSocketFactory(config.getSslContext().getSocketFactory());
        }
        if (config.getHostNameVerifier() != null) {
            okHttpClientBuilder.hostnameVerifier(config.getHostNameVerifier());
        }
        if (HttpLoggingFilter.isLoggingEnabled()) {
            okHttpClientBuilder.addInterceptor(new LoggingInterceptor());
        }
        this.client = okHttpClientBuilder.build();
        this.clientReq = new Request.Builder();
        this.populateHeaders(this.request);
        this.populateQueryParams(this.request);
    }

    public Response execute() throws Exception {
        RequestBody body = null;
        if (this.request.getEntity() != null) {
            Object content;
            if (InputStream.class.isAssignableFrom(this.request.getEntity().getClass())) {
                content = ByteStreams.toByteArray((InputStream)this.request.getEntity());
                body = RequestBody.create(MediaType.parse(this.request.getContentType()), content);
            } else {
                content = ObjectMapperSingleton.getContext(this.request.getEntity().getClass()).writer().writeValueAsString(this.request.getEntity());
                body = RequestBody.create(MediaType.parse(this.request.getContentType()), (String)content);
            }
        } else if (this.request.hasJson()) {
            body = RequestBody.create(MediaType.parse("application/json"), this.request.getJson());
        }
        if ((this.request.getMethod() == HttpMethod.POST || this.request.getMethod() == HttpMethod.PUT) && body == null) {
            body = RequestBody.create(null, Util.EMPTY_BYTE_ARRAY);
        }
        this.clientReq.method(this.request.getMethod().name(), body);
        Call call = this.client.newCall(this.clientReq.build());
        return call.execute();
    }

    public boolean hasEntity() {
        return this.request.getEntity() != null;
    }

    public int getRetries() {
        return this.retries;
    }

    public HttpCommand<R> incrementRetriesAndReturn() {
        this.initialize();
        ++this.retries;
        return this;
    }

    public HttpRequest<R> getRequest() {
        return this.request;
    }

    private void populateQueryParams(HttpRequest<R> request) {
        StringBuilder url = new StringBuilder();
        url.append(new EndpointURIFromRequestFunction().apply(request));
        if (!request.hasQueryParams()) {
            this.clientReq.url(url.toString());
            return;
        }
        url.append("?");
        for (Map.Entry<String, List<Object>> entry : request.getQueryParams().entrySet()) {
            for (Object o : entry.getValue()) {
                try {
                    url.append(URLEncoder.encode(entry.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(String.valueOf(o), "UTF-8"));
                    url.append("&");
                }
                catch (UnsupportedEncodingException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (url.charAt(url.length() - 1) == '&') {
            url.deleteCharAt(url.length() - 1);
        }
        this.clientReq.url(url.toString());
    }

    private void populateHeaders(HttpRequest<R> request) {
        if (!request.hasHeaders()) {
            return;
        }
        for (Map.Entry<String, Object> h2 : request.getHeaders().entrySet()) {
            this.clientReq.addHeader(h2.getKey(), String.valueOf(h2.getValue()));
        }
    }

    static class LoggingInterceptor
    implements Interceptor {
        LoggingInterceptor() {
        }

        @Override
        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            long t1 = System.nanoTime();
            System.err.println(String.format("Sending request %s on %s%n%s", request.url(), chain.connection(), request.headers()));
            Response response = chain.proceed(request);
            long t2 = System.nanoTime();
            System.err.println(String.format("Received response for %s in %.1fms%n%s", response.request().url(), (double)(t2 - t1) / 1000000.0, response.headers()));
            return response;
        }
    }
}

