/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.connectors.okhttp;

import okhttp3.Response;
import org.openstack4j.api.exceptions.ConnectionException;
import org.openstack4j.api.exceptions.ResponseException;
import org.openstack4j.connectors.okhttp.HttpCommand;
import org.openstack4j.connectors.okhttp.HttpResponseImpl;
import org.openstack4j.core.transport.HttpExecutorService;
import org.openstack4j.core.transport.HttpRequest;
import org.openstack4j.core.transport.HttpResponse;
import org.openstack4j.openstack.internal.OSAuthenticator;
import org.openstack4j.openstack.internal.OSClientSession;

public class HttpExecutorServiceImpl
implements HttpExecutorService {
    private static final String NAME = "OKHttp Connector";

    @Override
    public <R> HttpResponse execute(HttpRequest<R> request) {
        try {
            return this.invoke(request);
        }
        catch (ResponseException re) {
            throw re;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private <R> HttpResponse invoke(HttpRequest<R> request) throws Exception {
        HttpCommand<R> command = HttpCommand.create(request);
        try {
            return this.invokeRequest(command);
        }
        catch (Exception pe) {
            throw new ConnectionException(pe.getMessage(), 0, pe);
        }
    }

    private <R> HttpResponse invokeRequest(HttpCommand<R> command) throws Exception {
        Response response = command.execute();
        if (command.getRetries() == 0 && response.code() == 401 && !command.getRequest().getHeaders().containsKey("OS4J-Auth-Command")) {
            OSAuthenticator.reAuthenticate();
            command.getRequest().getHeaders().put("X-Auth-Token", OSClientSession.getCurrent().getTokenId());
            return this.invokeRequest(command.incrementRetriesAndReturn());
        }
        return HttpResponseImpl.wrap(response);
    }

    @Override
    public String getExecutorDisplayName() {
        return NAME;
    }
}

