/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.model.compute;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openstack4j.model.ModelEntity;

public interface VNCConsole
extends ModelEntity {
    public Type getType();

    public String getURL();

    public static enum Type {
        NOVNC("novnc"),
        XVPVNC("xvpvnc"),
        SPICE("spice-html5"),
        UNRECOGNIZED("unregonized");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Type value(String vncType) {
            if (vncType == null || vncType.isEmpty()) {
                return UNRECOGNIZED;
            }
            try {
                for (Type t2 : Type.values()) {
                    if (!t2.value.equalsIgnoreCase(vncType)) continue;
                    return t2;
                }
                return UNRECOGNIZED;
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

