/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.model.sahara;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.openstack4j.common.Buildable;
import org.openstack4j.model.ModelEntity;
import org.openstack4j.model.sahara.NodeGroup;
import org.openstack4j.model.sahara.ServiceConfig;
import org.openstack4j.model.sahara.ServiceInfo;
import org.openstack4j.model.sahara.builder.ClusterBuilder;

public interface Cluster
extends ModelEntity,
Buildable<ClusterBuilder> {
    public Status getStatus();

    public Map<String, ? extends ServiceInfo> getInfos();

    public String getClusterTemplateId();

    public Boolean isTransient();

    public String getDescription();

    public Map<String, ? extends ServiceConfig> getClusterConfigs();

    public Date getCreatedAt();

    public String getDefaultImageId();

    public String getUserKeypairId();

    public Date getUpdatedAt();

    public String getPluginName();

    public String getManagementNetworkId();

    public List<String> getAntiAffinity();

    public String getTenantId();

    public List<? extends NodeGroup> getNodeGroups();

    public String getManagementPublicKey();

    public String getStatusDescription();

    public String getHadoopVersion();

    public String getId();

    public String getTrustId();

    public String getName();

    public static enum Status {
        UNRECOGNIZED,
        VALIDATING,
        INFRAUPDATING,
        SPAWNING,
        WAITING,
        PREPARING,
        CONFIGURING,
        STARTING,
        ACTIVE,
        SCALING,
        ADDING,
        DECOMMISSIONING,
        DELETING,
        ERROR;


        @JsonCreator
        public static Status forValue(String value) {
            if (value != null) {
                for (Status s2 : Status.values()) {
                    if (!value.toUpperCase().startsWith(s2.name())) continue;
                    return s2;
                }
            }
            return UNRECOGNIZED;
        }
    }
}

