/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.compute.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.openstack4j.api.compute.ComputeImageService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.compute.Image;
import org.openstack4j.openstack.compute.domain.MetaDataWrapper;
import org.openstack4j.openstack.compute.domain.NovaImage;
import org.openstack4j.openstack.compute.internal.BaseComputeServices;

public class ComputeImageServiceImpl
extends BaseComputeServices
implements ComputeImageService {
    @Override
    public List<? extends Image> list() {
        return this.list(true);
    }

    @Override
    public List<? extends Image> list(boolean detailed) {
        String uri = detailed ? "/images/detail" : "/images";
        return this.get(NovaImage.NovaImages.class, this.uri(uri, new Object[0])).execute().getList();
    }

    @Override
    public Image get(String imageId) {
        Preconditions.checkNotNull(imageId);
        return this.get(NovaImage.class, this.uri("/images/%s", imageId)).execute();
    }

    @Override
    public ActionResponse delete(String imageId) {
        Preconditions.checkNotNull(imageId);
        return this.deleteWithResponse(this.uri("/images/%s", imageId)).execute();
    }

    @Override
    public Map<String, String> setMetaData(String imageId, Map<String, String> metadata) {
        Preconditions.checkNotNull(imageId);
        Preconditions.checkNotNull(metadata);
        return this.post(MetaDataWrapper.class, this.uri("/images/%s/metadata", imageId)).entity(MetaDataWrapper.wrap(metadata)).execute().getMetaData();
    }

    @Override
    public ActionResponse deleteMetaData(String imageId, String ... keys) {
        Preconditions.checkNotNull(imageId);
        for (String k : keys) {
            ActionResponse resp = this.deleteWithResponse(this.uri("/images/%s/metadata/%s", imageId, k)).execute();
            if (resp.isSuccess()) continue;
            return resp;
        }
        return ActionResponse.actionSuccess();
    }

    @Override
    public Map<String, String> getMetaData(String imageId) {
        Preconditions.checkNotNull(imageId);
        return this.get(MetaDataWrapper.class, this.uri("/images/%s/metadata", imageId)).execute().getMetaData();
    }
}

