/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.gbp.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.openstack4j.api.gbp.PolicyTargetService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.gbp.PolicyTarget;
import org.openstack4j.openstack.gbp.domain.GbpPolicyTarget;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class PolicyTargetServiceImpl
extends BaseNetworkingServices
implements PolicyTargetService {
    @Override
    public List<? extends PolicyTarget> list() {
        return this.get(GbpPolicyTarget.PolicyTargets.class, this.uri("/grouppolicy/policy_targets", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends PolicyTarget> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<GbpPolicyTarget.PolicyTargets> policytargetsInvocation = this.buildInvocation(filteringParams);
        return policytargetsInvocation.execute().getList();
    }

    private BaseOpenStackService.Invocation<GbpPolicyTarget.PolicyTargets> buildInvocation(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<GbpPolicyTarget.PolicyTargets> policytargetsInvocation = this.get(GbpPolicyTarget.PolicyTargets.class, "/grouppolicy/policy_targets");
        if (filteringParams == null) {
            return policytargetsInvocation;
        }
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                policytargetsInvocation = policytargetsInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return policytargetsInvocation;
    }

    @Override
    public PolicyTarget get(String id) {
        Preconditions.checkNotNull(id);
        return this.get(GbpPolicyTarget.class, this.uri("/grouppolicy/policy_targets/%s", id)).execute();
    }

    @Override
    public ActionResponse delete(String id) {
        Preconditions.checkNotNull(id);
        return this.deleteWithResponse(this.uri("/grouppolicy/policy_targets/%s", id)).execute();
    }

    @Override
    public PolicyTarget create(PolicyTarget policyTarget) {
        return this.post(GbpPolicyTarget.class, this.uri("/grouppolicy/policy_targets", new Object[0])).entity(policyTarget).execute();
    }

    @Override
    public PolicyTarget update(String policyTargetId, PolicyTarget policyTarget) {
        Preconditions.checkNotNull(policyTargetId);
        Preconditions.checkNotNull(policyTarget);
        return this.put(GbpPolicyTarget.class, this.uri("/grouppolicy/policy_targets/%s", policyTargetId)).entity(policyTarget).execute();
    }
}

