/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v3.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.Objects;
import java.util.List;
import java.util.Map;
import org.openstack4j.model.identity.v3.Policy;
import org.openstack4j.model.identity.v3.builder.PolicyBuilder;
import org.openstack4j.openstack.common.ListResult;

@JsonRootName(value="policy")
@JsonIgnoreProperties(ignoreUnknown=true)
public class KeystonePolicy
implements Policy {
    private static final long serialVersionUID = 1L;
    private String id;
    @JsonProperty(value="project_id")
    private String projectId;
    @JsonProperty(value="user_id")
    private String userId;
    private String type;
    private Map<String, String> links;
    private String blob;

    public static PolicyBuilder builder() {
        return new PolicyConcreteBuilder();
    }

    @Override
    public PolicyBuilder toBuilder() {
        return new PolicyConcreteBuilder(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getBlob() {
        return this.blob;
    }

    @Override
    public Map<String, String> getLinks() {
        return this.links;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("projectId", (Object)this.projectId).add("userId", (Object)this.userId).add("type", (Object)this.type).add("blob", (Object)this.blob).add("links", this.links).toString();
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.projectId, this.userId, this.type, this.blob, this.links);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KeystonePolicy that = (KeystonePolicy)KeystonePolicy.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.type, that.type) && Objects.equal(this.projectId, that.projectId) && Objects.equal(this.userId, that.userId) && Objects.equal(this.blob, that.blob) && Objects.equal(this.links, that.links);
    }

    public static class PolicyConcreteBuilder
    implements PolicyBuilder {
        KeystonePolicy model;

        PolicyConcreteBuilder() {
            this(new KeystonePolicy());
        }

        PolicyConcreteBuilder(KeystonePolicy model) {
            this.model = model;
        }

        @Override
        public Policy build() {
            return this.model;
        }

        @Override
        public PolicyBuilder from(Policy in) {
            if (in != null) {
                this.model = (KeystonePolicy)in;
            }
            return this;
        }

        @Override
        public PolicyBuilder id(String id) {
            this.model.id = id;
            return this;
        }

        @Override
        public PolicyBuilder type(String type) {
            this.model.type = type;
            return this;
        }

        @Override
        public PolicyBuilder blob(String blob) {
            this.model.blob = blob;
            return this;
        }

        @Override
        public PolicyBuilder links(Map<String, String> links) {
            this.model.links = links;
            return this;
        }

        @Override
        public PolicyBuilder projectId(String projectId) {
            this.model.projectId = projectId;
            return this;
        }

        @Override
        public PolicyBuilder userId(String userId) {
            this.model.userId = userId;
            return this;
        }
    }

    public static class Policies
    extends ListResult<KeystonePolicy> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="policies")
        private List<KeystonePolicy> list;

        @Override
        public List<KeystonePolicy> value() {
            return this.list;
        }
    }
}

