/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v3.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.identity.v3.PolicyService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.identity.v3.Policy;
import org.openstack4j.openstack.identity.v3.domain.KeystonePolicy;
import org.openstack4j.openstack.internal.BaseOpenStackService;

public class PolicyServiceImpl
extends BaseOpenStackService
implements PolicyService {
    @Override
    public Policy create(Policy policy) {
        Preconditions.checkNotNull(policy);
        return this.post(KeystonePolicy.class, this.uri("/policies", new Object[0])).entity(policy).execute();
    }

    @Override
    public Policy create(String blob, String type, String projectId, String userId) {
        Preconditions.checkNotNull(blob);
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull(projectId);
        Preconditions.checkNotNull(userId);
        return this.create((Policy)KeystonePolicy.builder().blob(blob).type(type).projectId(projectId).userId(userId).build());
    }

    @Override
    public Policy get(String policyId) {
        Preconditions.checkNotNull(policyId);
        return this.get(KeystonePolicy.class, "/policies", "/", policyId).execute();
    }

    @Override
    public Policy update(Policy policy) {
        Preconditions.checkNotNull(policy);
        return this.patch(KeystonePolicy.class, "/policies", "/", policy.getId()).entity(policy).execute();
    }

    @Override
    public ActionResponse delete(String policyId) {
        Preconditions.checkNotNull(policyId);
        return this.deleteWithResponse("/policies", "/", policyId).execute();
    }

    @Override
    public List<? extends Policy> list() {
        return this.get(KeystonePolicy.Policies.class, this.uri("/policies", new Object[0])).execute().getList();
    }
}

