/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v3.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.identity.v3.ProjectService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.identity.v3.Project;
import org.openstack4j.openstack.identity.v3.domain.KeystoneProject;
import org.openstack4j.openstack.internal.BaseOpenStackService;

public class ProjectServiceImpl
extends BaseOpenStackService
implements ProjectService {
    @Override
    public Project create(Project project) {
        Preconditions.checkNotNull(project);
        return this.post(KeystoneProject.class, "/projects").entity(project).execute();
    }

    @Override
    public Project create(String domainId, String name, String description, boolean enabled) {
        Preconditions.checkNotNull(domainId);
        Preconditions.checkNotNull(name);
        Preconditions.checkNotNull(description);
        Preconditions.checkNotNull(enabled);
        return this.create((Project)KeystoneProject.builder().domainId(domainId).name(name).description(description).enabled(enabled).build());
    }

    @Override
    public Project get(String projectId) {
        Preconditions.checkNotNull(projectId);
        return this.get(KeystoneProject.class, "/projects", "/", projectId).execute();
    }

    @Override
    public List<? extends Project> getByName(String projectName) {
        Preconditions.checkNotNull(projectName);
        return this.get(KeystoneProject.Projects.class, this.uri("/projects", new Object[0])).param("name", projectName).execute().getList();
    }

    @Override
    public Project getByName(String projectName, String domainId) {
        Preconditions.checkNotNull(projectName);
        Preconditions.checkNotNull(domainId);
        return (Project)this.get(KeystoneProject.Projects.class, this.uri("/projects", new Object[0])).param("name", projectName).param("domain_id", domainId).execute().first();
    }

    @Override
    public Project update(Project project) {
        Preconditions.checkNotNull(project);
        return this.patch(KeystoneProject.class, "/projects", "/", project.getId()).entity(project).execute();
    }

    @Override
    public ActionResponse delete(String projectId) {
        Preconditions.checkNotNull(projectId);
        return this.deleteWithResponse("/projects", "/", projectId).execute();
    }

    @Override
    public List<? extends Project> list() {
        return this.get(KeystoneProject.Projects.class, this.uri("/projects", new Object[0])).execute().getList();
    }
}

