/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v3.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.identity.v3.RoleService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.identity.v3.Role;
import org.openstack4j.model.identity.v3.RoleAssignment;
import org.openstack4j.openstack.identity.v3.domain.KeystoneRole;
import org.openstack4j.openstack.identity.v3.domain.KeystoneRoleAssignment;
import org.openstack4j.openstack.internal.BaseOpenStackService;

public class RoleServiceImpl
extends BaseOpenStackService
implements RoleService {
    @Override
    public ActionResponse grantProjectUserRole(String projectId, String userId, String roleId) {
        Preconditions.checkNotNull(userId);
        Preconditions.checkNotNull(projectId);
        Preconditions.checkNotNull(roleId);
        return this.put(ActionResponse.class, this.uri("projects/%s/users/%s/roles/%s", projectId, userId, roleId)).execute();
    }

    @Override
    public ActionResponse revokeProjectUserRole(String projectId, String userId, String roleId) {
        Preconditions.checkNotNull(userId);
        Preconditions.checkNotNull(projectId);
        Preconditions.checkNotNull(roleId);
        return this.deleteWithResponse(this.uri("projects/%s/users/%s/roles/%s", projectId, userId, roleId)).execute();
    }

    @Override
    public ActionResponse checkProjectUserRole(String projectId, String userId, String roleId) {
        Preconditions.checkNotNull(projectId);
        Preconditions.checkNotNull(userId);
        Preconditions.checkNotNull(roleId);
        return this.head(ActionResponse.class, this.uri("/projects/%s/users/%s/roles/%s", projectId, userId, roleId)).execute();
    }

    @Override
    public ActionResponse grantDomainUserRole(String domainId, String userId, String roleId) {
        Preconditions.checkNotNull(userId);
        Preconditions.checkNotNull(domainId);
        Preconditions.checkNotNull(roleId);
        return this.put(ActionResponse.class, this.uri("domains/%s/users/%s/roles/%s", domainId, userId, roleId)).execute();
    }

    @Override
    public ActionResponse revokeDomainUserRole(String domainId, String userId, String roleId) {
        Preconditions.checkNotNull(userId);
        Preconditions.checkNotNull(domainId);
        Preconditions.checkNotNull(roleId);
        return this.deleteWithResponse(this.uri("domains/%s/users/%s/roles/%s", domainId, userId, roleId)).execute();
    }

    @Override
    public ActionResponse checkDomainUserRole(String domainId, String userId, String roleId) {
        Preconditions.checkNotNull(domainId);
        Preconditions.checkNotNull(userId);
        Preconditions.checkNotNull(roleId);
        return this.head(ActionResponse.class, this.uri("/domains/%s/users/%s/roles/%s", domainId, userId, roleId)).execute();
    }

    @Override
    public List<? extends Role> list() {
        return this.get(KeystoneRole.Roles.class, this.uri("/roles", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends Role> getByName(String name) {
        Preconditions.checkNotNull(name);
        return this.get(KeystoneRole.Roles.class, "/roles").param("name", name).execute().getList();
    }

    @Override
    public Role create(Role role) {
        Preconditions.checkNotNull(role);
        return this.post(KeystoneRole.class, this.uri("/roles", new Object[0])).entity(role).execute();
    }

    @Override
    public Role create(String name) {
        Preconditions.checkNotNull(name);
        return this.create((Role)KeystoneRole.builder().name(name).build());
    }

    @Override
    public Role update(Role role) {
        Preconditions.checkNotNull(role);
        return this.patch(KeystoneRole.class, "/roles", "/", role.getId()).entity(role).execute();
    }

    @Override
    public ActionResponse delete(String roleId) {
        Preconditions.checkNotNull(roleId);
        return this.deleteWithResponse("/roles", "/", roleId).execute();
    }

    @Override
    public Role get(String roleId) {
        Preconditions.checkNotNull(roleId);
        return this.get(KeystoneRole.class, "/roles", "/", roleId).execute();
    }

    @Override
    public List<? extends RoleAssignment> listRoleAssignments(String projectId) {
        Preconditions.checkNotNull(projectId);
        return this.get(KeystoneRoleAssignment.RoleAssignments.class, "role_assignments").param("scope.project.id", projectId).param("effective", "true").execute().getList();
    }

    @Override
    public ActionResponse grantProjectGroupRole(String projectId, String groupId, String roleId) {
        Preconditions.checkNotNull(projectId);
        Preconditions.checkNotNull(groupId);
        Preconditions.checkNotNull(roleId);
        return this.put(ActionResponse.class, this.uri("projects/%s/groups/%s/roles/%s", projectId, groupId, roleId)).execute();
    }

    @Override
    public ActionResponse revokeProjectGroupRole(String projectId, String groupId, String roleId) {
        Preconditions.checkNotNull(projectId);
        Preconditions.checkNotNull(groupId);
        Preconditions.checkNotNull(roleId);
        return this.deleteWithResponse(this.uri("projects/%s/groups/%s/roles/%s", projectId, groupId, roleId)).execute();
    }

    @Override
    public ActionResponse checkProjectGroupRole(String projectId, String groupId, String roleId) {
        Preconditions.checkNotNull(projectId);
        Preconditions.checkNotNull(groupId);
        Preconditions.checkNotNull(roleId);
        return this.head(ActionResponse.class, this.uri("/projects/%s/groups/%s/roles/%s", projectId, groupId, roleId)).execute();
    }

    @Override
    public ActionResponse grantDomainGroupRole(String domainId, String groupId, String roleId) {
        Preconditions.checkNotNull(domainId);
        Preconditions.checkNotNull(groupId);
        Preconditions.checkNotNull(roleId);
        return this.put(ActionResponse.class, this.uri("domains/%s/groups/%s/roles/%s", domainId, groupId, roleId)).execute();
    }

    @Override
    public ActionResponse revokeDomainGroupRole(String domainId, String groupId, String roleId) {
        Preconditions.checkNotNull(domainId);
        Preconditions.checkNotNull(groupId);
        Preconditions.checkNotNull(roleId);
        return this.deleteWithResponse(this.uri("domains/%s/groups/%s/roles/%s", domainId, groupId, roleId)).execute();
    }

    @Override
    public ActionResponse checkDomainGroupRole(String domainId, String groupId, String roleId) {
        Preconditions.checkNotNull(domainId);
        Preconditions.checkNotNull(groupId);
        Preconditions.checkNotNull(roleId);
        return this.head(ActionResponse.class, this.uri("/domains/%s/groups/%s/roles/%s", domainId, groupId, roleId)).execute();
    }
}

