/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v3.internal;

import com.google.common.base.Preconditions;
import org.openstack4j.api.identity.v3.TokenService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.identity.v3.Token;
import org.openstack4j.openstack.identity.v3.domain.KeystoneToken;
import org.openstack4j.openstack.internal.BaseOpenStackService;

public class TokenServiceImpl
extends BaseOpenStackService
implements TokenService {
    @Override
    public Token get(String tokenId) {
        Preconditions.checkNotNull(tokenId);
        return this.get(KeystoneToken.class, "/auth/tokens").header("X-Subject-Token", tokenId).execute();
    }

    @Override
    public ActionResponse check(String tokenId) {
        Preconditions.checkNotNull(tokenId);
        return this.head(ActionResponse.class, "/auth/tokens").header("X-Subject-Token", tokenId).execute();
    }

    @Override
    public ActionResponse delete(String tokenId) {
        Preconditions.checkNotNull(tokenId);
        return this.deleteWithResponse("/auth/tokens").header("X-Subject-Token", tokenId).execute();
    }
}

