/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.manila.internal;

import com.google.common.base.Preconditions;
import org.openstack4j.api.manila.QuotaSetService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.manila.QuotaSet;
import org.openstack4j.model.manila.QuotaSetUpdateOptions;
import org.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import org.openstack4j.openstack.manila.domain.ManilaQuotaSet;
import org.openstack4j.openstack.manila.domain.ManilaQuotaSetUpdate;
import org.openstack4j.openstack.manila.internal.BaseShareServices;

public class QuotaSetServiceImpl
extends BaseShareServices
implements QuotaSetService {
    @Override
    public QuotaSet get(String tenantId) {
        return this.get(tenantId, null);
    }

    @Override
    public QuotaSet get(String tenantId, String userId) {
        Preconditions.checkNotNull(tenantId);
        return this.get(ManilaQuotaSet.class, this.uri("/os-quota-sets/%s", tenantId)).param(userId != null, "user_id", userId).execute();
    }

    @Override
    public QuotaSet update(String tenantId, QuotaSetUpdateOptions options) {
        return this.update(tenantId, null, options);
    }

    @Override
    public QuotaSet update(String tenantId, String userId, QuotaSetUpdateOptions options) {
        Preconditions.checkNotNull(tenantId);
        Preconditions.checkNotNull(options);
        return this.put(ManilaQuotaSet.class, this.uri("/os-quota-sets/%s", tenantId)).param(userId != null, "user_id", userId).entity(ManilaQuotaSetUpdate.fromOptions(options)).execute();
    }

    @Override
    public ActionResponse delete(String tenantId) {
        return this.delete(tenantId, null);
    }

    @Override
    public ActionResponse delete(String tenantId, String userId) {
        Preconditions.checkNotNull(tenantId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/os-quota-sets/%s", tenantId)).param(userId != null, "user_id", userId).executeWithResponse());
    }

    @Override
    public QuotaSet getDefault(String tenantId) {
        Preconditions.checkNotNull(tenantId);
        return this.get(ManilaQuotaSet.class, this.uri("/os-quota-sets/%s/defaults", tenantId)).execute();
    }
}

