/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import org.openstack4j.api.Apis;
import org.openstack4j.model.network.Network;
import org.openstack4j.model.network.NetworkType;
import org.openstack4j.model.network.State;
import org.openstack4j.model.network.Subnet;
import org.openstack4j.model.network.builder.NetworkBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.networking.domain.NeutronSubnet;

@JsonRootName(value="network")
public class NeutronNetwork
implements Network {
    private static final long serialVersionUID = 1L;
    private State status;
    @JsonProperty
    private List<String> subnets;
    private List<NeutronSubnet> neutronSubnets;
    private String name;
    @JsonProperty(value="provider:physical_network")
    private String providerPhyNet;
    @JsonProperty(value="admin_state_up")
    private Boolean adminStateUp;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    @JsonProperty(value="provider:network_type")
    private NetworkType networkType;
    @JsonProperty(value="router:external")
    private Boolean routerExternal;
    private String id;
    private Boolean shared;
    @JsonProperty(value="provider:segmentation_id")
    private String providerSegID;

    public static NetworkBuilder builder() {
        return new NetworkConcreteBuilder();
    }

    @Override
    public NetworkBuilder toBuilder() {
        return new NetworkConcreteBuilder(this);
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public State getStatus() {
        return this.status;
    }

    @Override
    public List<String> getSubnets() {
        return this.subnets;
    }

    @Override
    public List<? extends Subnet> getNeutronSubnets() {
        if (this.neutronSubnets == null && this.subnets != null && this.subnets.size() > 0) {
            this.neutronSubnets = new ArrayList<NeutronSubnet>();
            for (String subnetId : this.subnets) {
                NeutronSubnet sub = (NeutronSubnet)Apis.getNetworkingServices().subnet().get(subnetId);
                this.neutronSubnets.add(sub);
            }
        }
        return this.neutronSubnets;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getProviderPhyNet() {
        return this.providerPhyNet;
    }

    @Override
    public boolean isAdminStateUp() {
        return this.adminStateUp != null && this.adminStateUp != false;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public NetworkType getNetworkType() {
        return this.networkType;
    }

    @Override
    @JsonIgnore
    public boolean isRouterExternal() {
        return this.routerExternal != null && this.routerExternal != false;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isShared() {
        return this.shared != null && this.shared != false;
    }

    @Override
    public String getProviderSegID() {
        return this.providerSegID;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("status", (Object)this.status).add("subnets", this.subnets).add("provider:physical_network", (Object)this.providerPhyNet).add("adminStateUp", (Object)this.adminStateUp).add("tenantId", (Object)this.tenantId).add("provider:network_type", (Object)this.networkType).add("router:external", (Object)this.routerExternal).add("id", (Object)this.id).add("shared", (Object)this.shared).add("provider:segmentation_id", (Object)this.providerSegID).toString();
    }

    public static class NetworkConcreteBuilder
    implements NetworkBuilder {
        private NeutronNetwork m;

        public NetworkConcreteBuilder() {
            this(new NeutronNetwork());
        }

        public NetworkConcreteBuilder(NeutronNetwork m4) {
            this.m = m4;
        }

        @Override
        public NetworkBuilder name(String name) {
            this.m.name = name;
            return this;
        }

        @Override
        public NetworkBuilder adminStateUp(boolean adminStateUp) {
            this.m.adminStateUp = adminStateUp;
            return this;
        }

        @Override
        public NetworkBuilder networkType(NetworkType networkType) {
            this.m.networkType = networkType;
            return this;
        }

        @Override
        public NetworkBuilder physicalNetwork(String providerPhysicalNetwork) {
            this.m.providerPhyNet = providerPhysicalNetwork;
            return this;
        }

        @Override
        public NetworkBuilder segmentId(String providerSegmentationId) {
            this.m.providerSegID = providerSegmentationId;
            return this;
        }

        @Override
        public NetworkBuilder tenantId(String tenantId) {
            this.m.tenantId = tenantId;
            return this;
        }

        @Override
        public NetworkBuilder isShared(boolean shared) {
            this.m.shared = shared;
            return this;
        }

        @Override
        public NetworkBuilder isRouterExternal(boolean routerExternal) {
            this.m.routerExternal = routerExternal;
            return this;
        }

        @Override
        public Network build() {
            return this.m;
        }

        @Override
        public NetworkBuilder from(Network in) {
            this.m = (NeutronNetwork)in;
            return this;
        }
    }

    public static class Networks
    extends ListResult<NeutronNetwork> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="networks")
        private List<NeutronNetwork> networks;

        @Override
        public List<NeutronNetwork> value() {
            return this.networks;
        }
    }
}

