/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain.ext;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.Objects;
import java.util.List;
import org.openstack4j.model.network.ext.Firewall;
import org.openstack4j.model.network.ext.builder.FirewallBuilder;
import org.openstack4j.openstack.common.ListResult;

@JsonRootName(value="firewall")
@JsonIgnoreProperties(ignoreUnknown=true)
public class NeutronFirewall
implements Firewall {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    private String description;
    private Boolean shared;
    @JsonProperty(value="admin_state_up")
    private Boolean adminStateUp;
    private FirewallStatus status;
    @JsonProperty(value="firewall_policy_id")
    private String policyId;

    @Override
    public FirewallBuilder toBuilder() {
        return new FirewallConcreteBuilder(this);
    }

    public static FirewallBuilder builder() {
        return new FirewallConcreteBuilder();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Boolean isAdminStateUp() {
        return this.adminStateUp != null && this.adminStateUp != false;
    }

    @Override
    public Boolean isShared() {
        return this.shared != null && this.shared != false;
    }

    @Override
    public FirewallStatus getStatus() {
        return this.status;
    }

    @Override
    @JsonIgnore
    public String getPolicy() {
        return this.policyId;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("status", (Object)this.status).add("policyId", (Object)this.policyId).add("shared", (Object)this.shared).add("adminStateUp", (Object)this.adminStateUp).add("tenantId", (Object)this.tenantId).add("description", (Object)this.description).toString();
    }

    public static class FirewallConcreteBuilder
    implements FirewallBuilder {
        NeutronFirewall f;

        @Override
        public Firewall build() {
            return this.f;
        }

        public FirewallConcreteBuilder() {
            this(new NeutronFirewall());
        }

        public FirewallConcreteBuilder(NeutronFirewall f) {
            this.f = f;
        }

        @Override
        public FirewallBuilder from(Firewall in) {
            this.f = (NeutronFirewall)in;
            return this;
        }

        @Override
        public FirewallBuilder tenantId(String tenantId) {
            this.f.tenantId = tenantId;
            return this;
        }

        @Override
        public FirewallBuilder name(String name) {
            this.f.name = name;
            return this;
        }

        @Override
        public FirewallBuilder description(String description) {
            this.f.description = description;
            return this;
        }

        @Override
        public FirewallBuilder adminStateUp(Boolean adminStateUp) {
            this.f.adminStateUp = adminStateUp;
            return this;
        }

        @Override
        public FirewallBuilder shared(Boolean shared) {
            this.f.shared = shared;
            return this;
        }

        @Override
        public FirewallBuilder policy(String policyId) {
            this.f.policyId = policyId;
            return this;
        }
    }

    public static class Firewalls
    extends ListResult<NeutronFirewall> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="firewalls")
        List<NeutronFirewall> firewalls;

        @Override
        public List<NeutronFirewall> value() {
            return this.firewalls;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).omitNullValues().add("firewalls", this.firewalls).toString();
        }
    }

    public static enum FirewallStatus {
        ACTIVE,
        DOWN,
        BUILD,
        ERROR,
        PENDING_CREATE,
        PENDING_UPDATE,
        PENDING_DELETE,
        UNRECOGNIZED;


        @JsonCreator
        public static FirewallStatus forValue(String value) {
            if (value != null) {
                for (FirewallStatus s2 : FirewallStatus.values()) {
                    if (!s2.name().equalsIgnoreCase(value)) continue;
                    return s2;
                }
            }
            return UNRECOGNIZED;
        }
    }
}

