/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain.ext;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.Objects;
import org.openstack4j.model.network.ext.HealthMonitorUpdate;
import org.openstack4j.model.network.ext.builder.HealthMonitorUpdateBuilder;

@JsonRootName(value="health_monitor")
@JsonIgnoreProperties(ignoreUnknown=true)
public class NeutronHealthMonitorUpdate
implements HealthMonitorUpdate {
    private static final long serialVersionUID = 1L;
    private Integer delay;
    private Integer timeout;
    @JsonProperty(value="max_retries")
    private Integer maxRetries;
    @JsonProperty(value="http_method")
    private String httpMethod;
    @JsonProperty(value="url_path")
    private String urlPath;
    @JsonProperty(value="expected_codes")
    private String expectedCodes;
    @JsonProperty(value="admin_state_up")
    private boolean adminStateUp;

    @Override
    public HealthMonitorUpdateBuilder toBuilder() {
        return new HealthMonitorUpdateConcreteBuilder(this);
    }

    @Override
    public Integer getDelay() {
        return this.delay;
    }

    @Override
    public String getUrlPath() {
        return this.urlPath;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("delay", (Object)this.delay).add("urlPath", (Object)this.urlPath).add("adminStateUp", this.adminStateUp).add("expectedCodes", (Object)this.expectedCodes).add("httpMethod", (Object)this.httpMethod).add("maxRetries", (Object)this.maxRetries).add("timeout", (Object)this.timeout).toString();
    }

    public static HealthMonitorUpdateBuilder builder() {
        return new HealthMonitorUpdateConcreteBuilder();
    }

    @Override
    public Integer getTimeout() {
        return this.timeout;
    }

    @Override
    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    @Override
    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public String getExpectedCodes() {
        return this.expectedCodes;
    }

    @Override
    public boolean isAdminStateUp() {
        return this.adminStateUp;
    }

    public static class HealthMonitorUpdateConcreteBuilder
    implements HealthMonitorUpdateBuilder {
        NeutronHealthMonitorUpdate m;

        public HealthMonitorUpdateConcreteBuilder() {
            this(new NeutronHealthMonitorUpdate());
        }

        public HealthMonitorUpdateConcreteBuilder(NeutronHealthMonitorUpdate m4) {
            this.m = m4;
        }

        @Override
        public HealthMonitorUpdate build() {
            return this.m;
        }

        @Override
        public HealthMonitorUpdateBuilder from(HealthMonitorUpdate in) {
            this.m = (NeutronHealthMonitorUpdate)in;
            return this;
        }

        @Override
        public HealthMonitorUpdateBuilder delay(Integer delay) {
            this.m.delay = delay;
            return this;
        }

        @Override
        public HealthMonitorUpdateBuilder urlPath(String urlPath) {
            this.m.urlPath = urlPath;
            return this;
        }

        @Override
        public HealthMonitorUpdateBuilder expectedCodes(String expectedCodes) {
            this.m.expectedCodes = expectedCodes;
            return this;
        }

        @Override
        public HealthMonitorUpdateBuilder httpMethod(String httpMethod) {
            this.m.httpMethod = httpMethod;
            return this;
        }

        @Override
        public HealthMonitorUpdateBuilder maxRetries(Integer maxRetries) {
            this.m.maxRetries = maxRetries;
            return this;
        }

        @Override
        public HealthMonitorUpdateBuilder adminStateUp(boolean adminStateUp) {
            this.m.adminStateUp = adminStateUp;
            return this;
        }

        @Override
        public HealthMonitorUpdateBuilder timeout(Integer timeout) {
            this.m.timeout = timeout;
            return this;
        }
    }
}

