/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain.ext;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.Objects;
import java.util.List;
import org.openstack4j.model.network.ext.Member;
import org.openstack4j.model.network.ext.builder.MemberBuilder;
import org.openstack4j.openstack.common.ListResult;

@JsonRootName(value="member")
@JsonIgnoreProperties(ignoreUnknown=true)
public class NeutronMember
implements Member {
    private static final long serialVersionUID = 1L;
    private String id;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    private String address;
    @JsonProperty(value="protocol_port")
    private Integer protocolPort;
    private Integer weight;
    @JsonProperty(value="admin_state_up")
    private boolean adminStateUp;
    private String status;
    @JsonProperty(value="pool_id")
    private String poolId;

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public boolean isAdminStateUp() {
        return this.adminStateUp;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Integer getProtocolPort() {
        return this.protocolPort;
    }

    @Override
    public Integer getWeight() {
        return this.weight;
    }

    @Override
    public String getPoolId() {
        return this.poolId;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("address", (Object)this.address).add("adminStateUp", this.adminStateUp).add("poolId", (Object)this.poolId).add("protocolPort", (Object)this.protocolPort).add("status", (Object)this.status).add("tenantId", (Object)this.tenantId).add("weight", (Object)this.weight).toString();
    }

    @Override
    public MemberBuilder toBuilder() {
        return new MemberConcreteBuilder(this);
    }

    public static MemberBuilder builder() {
        return new MemberConcreteBuilder();
    }

    public static class MemberConcreteBuilder
    implements MemberBuilder {
        private NeutronMember m;

        public MemberConcreteBuilder() {
            this(new NeutronMember());
        }

        public MemberConcreteBuilder(NeutronMember m4) {
            this.m = m4;
        }

        @Override
        public Member build() {
            return this.m;
        }

        @Override
        public MemberBuilder from(Member in) {
            this.m = (NeutronMember)in;
            return this;
        }

        @Override
        public MemberBuilder tenantId(String tenantId) {
            this.m.tenantId = tenantId;
            return this;
        }

        @Override
        public MemberBuilder adminStateUp(boolean adminStateUp) {
            this.m.adminStateUp = adminStateUp;
            return this;
        }

        @Override
        public MemberBuilder address(String address) {
            this.m.address = address;
            return this;
        }

        @Override
        public MemberBuilder protocolPort(Integer protocolPort) {
            this.m.protocolPort = protocolPort;
            return this;
        }

        @Override
        public MemberBuilder weight(Integer weight) {
            this.m.weight = weight;
            return this;
        }

        @Override
        public MemberBuilder poolId(String lbPoolId) {
            this.m.poolId = lbPoolId;
            return this;
        }
    }

    public static class Members
    extends ListResult<NeutronMember> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="members")
        private List<NeutronMember> members;

        @Override
        public List<NeutronMember> value() {
            return this.members;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).omitNullValues().add("members", this.members).toString();
        }
    }
}

