/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain.ext;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.openstack4j.model.network.ext.SessionPersistence;
import org.openstack4j.model.network.ext.VipUpdate;
import org.openstack4j.model.network.ext.builder.VipUpdateBuilder;
import org.openstack4j.openstack.networking.domain.ext.NeutronSessionPersistence;

@JsonRootName(value="vip")
@JsonIgnoreProperties(ignoreUnknown=true)
public class NeutronVipUpdate
implements VipUpdate {
    private static final long serialVersionUID = 1L;
    private String name;
    private String description;
    @JsonProperty(value="pool_id")
    private String poolId;
    @JsonProperty(value="session_persistence")
    private NeutronSessionPersistence sessionPersistence;
    @JsonProperty(value="connection_limit")
    private Integer connectionLimit;
    @JsonProperty(value="admin_state_up")
    private boolean adminStateUp;

    @Override
    public VipUpdateBuilder toBuilder() {
        return new VipUpdateContreteBuilder();
    }

    @Override
    public boolean isAdminStateUp() {
        return this.adminStateUp;
    }

    @Override
    public Integer getConnectionLimit() {
        return this.connectionLimit;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPoolId() {
        return this.poolId;
    }

    @Override
    public SessionPersistence getSessionPersistence() {
        return this.sessionPersistence;
    }

    public static VipUpdateBuilder builder() {
        return new VipUpdateContreteBuilder();
    }

    public static class VipUpdateContreteBuilder
    implements VipUpdateBuilder {
        private NeutronVipUpdate m;

        public VipUpdateContreteBuilder() {
            this(new NeutronVipUpdate());
        }

        public VipUpdateContreteBuilder(NeutronVipUpdate m4) {
            this.m = m4;
        }

        @Override
        public VipUpdate build() {
            return this.m;
        }

        @Override
        public VipUpdateBuilder from(VipUpdate in) {
            this.m = (NeutronVipUpdate)in;
            return this;
        }

        @Override
        public VipUpdateBuilder name(String name) {
            this.m.name = name;
            return this;
        }

        @Override
        public VipUpdateBuilder description(String description) {
            this.m.description = description;
            return this;
        }

        @Override
        public VipUpdateBuilder poolId(String poolId) {
            this.m.poolId = poolId;
            return this;
        }

        @Override
        public VipUpdateBuilder sessionPersistence(SessionPersistence sessionPersistence) {
            this.m.sessionPersistence = (NeutronSessionPersistence)sessionPersistence;
            return this;
        }

        @Override
        public VipUpdateBuilder connectionLimit(Integer connectionLimit) {
            this.m.connectionLimit = connectionLimit;
            return this;
        }

        @Override
        public VipUpdateBuilder adminStateUp(boolean adminStateUp) {
            this.m.adminStateUp = adminStateUp;
            return this;
        }
    }
}

