/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.networking.RouterService;
import org.openstack4j.core.transport.ExecutionOptions;
import org.openstack4j.core.transport.propagation.PropagateOnStatus;
import org.openstack4j.model.ModelEntity;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.AttachInterfaceType;
import org.openstack4j.model.network.HostRoute;
import org.openstack4j.model.network.Router;
import org.openstack4j.model.network.RouterInterface;
import org.openstack4j.model.network.builder.RouterBuilder;
import org.openstack4j.openstack.networking.domain.AddRouterInterfaceAction;
import org.openstack4j.openstack.networking.domain.NeutronRouter;
import org.openstack4j.openstack.networking.domain.NeutronRouterInterface;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class RouterServiceImpl
extends BaseNetworkingServices
implements RouterService {
    @Override
    public List<? extends Router> list() {
        return this.get(NeutronRouter.Routers.class, this.uri("/routers", new Object[0])).execute().getList();
    }

    @Override
    public Router get(String routerId) {
        Preconditions.checkNotNull(routerId);
        return this.get(NeutronRouter.class, this.uri("/routers/%s", routerId)).execute();
    }

    @Override
    public ActionResponse delete(String routerId) {
        Preconditions.checkNotNull(routerId);
        return this.deleteWithResponse(this.uri("/routers/%s", routerId)).execute();
    }

    @Override
    public Router create(String name, boolean adminStateUp) {
        Preconditions.checkNotNull(name);
        return this.post(NeutronRouter.class, this.uri("/routers", new Object[0])).entity((ModelEntity)NeutronRouter.builder().name(name).adminStateUp(adminStateUp).build()).execute();
    }

    @Override
    public Router create(Router router) {
        Preconditions.checkNotNull(router);
        return this.post(NeutronRouter.class, this.uri("/routers", new Object[0])).entity(router).execute();
    }

    @Override
    public Router update(Router router) {
        Preconditions.checkNotNull(router);
        Preconditions.checkNotNull(router.getId());
        RouterBuilder rb = NeutronRouter.builder().name(router.getName()).adminStateUp(router.isAdminStateUp()).externalGateway(router.getExternalGatewayInfo());
        List<? extends HostRoute> routes = router.getRoutes();
        if (routes != null) {
            for (HostRoute hostRoute : routes) {
                rb.route(hostRoute.getDestination(), hostRoute.getNexthop());
            }
        }
        return this.put(NeutronRouter.class, this.uri("/routers/%s", router.getId())).entity((ModelEntity)rb.build()).execute();
    }

    @Override
    public Router toggleAdminStateUp(String routerId, boolean adminStateUp) {
        Preconditions.checkNotNull(routerId);
        return this.put(NeutronRouter.class, this.uri("/routers/%s", routerId)).entity((ModelEntity)NeutronRouter.builder().adminStateUp(adminStateUp).build()).execute();
    }

    @Override
    public RouterInterface attachInterface(String routerId, AttachInterfaceType type, String portOrSubnetId) {
        Preconditions.checkNotNull(routerId);
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull(portOrSubnetId);
        return this.put(NeutronRouterInterface.class, this.uri("/routers/%s/add_router_interface", routerId)).entity(AddRouterInterfaceAction.create(type, portOrSubnetId)).execute();
    }

    @Override
    public RouterInterface detachInterface(String routerId, String subnetId, String portId) {
        Preconditions.checkNotNull(routerId);
        Preconditions.checkState(subnetId != null || portId != null, "Either a Subnet or Port identifier must be set");
        return this.put(NeutronRouterInterface.class, this.uri("/routers/%s/remove_router_interface", routerId)).entity(new NeutronRouterInterface(subnetId, portId)).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }
}

