/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.internal.ext;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.openstack4j.api.networking.ext.FirewallRuleService;
import org.openstack4j.core.transport.ExecutionOptions;
import org.openstack4j.core.transport.propagation.PropagateOnStatus;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.ext.FirewallRule;
import org.openstack4j.model.network.ext.FirewallRuleUpdate;
import org.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.networking.domain.ext.NeutronFirewallRule;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class FirewallRuleServiceImpl
extends BaseNetworkingServices
implements FirewallRuleService {
    @Override
    public List<? extends FirewallRule> list() {
        return this.get(NeutronFirewallRule.FirewallRules.class, this.uri("/fw/firewall_rules", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends FirewallRule> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<NeutronFirewallRule.FirewallRules> req = this.get(NeutronFirewallRule.FirewallRules.class, this.uri("/fw/firewall_rules", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public FirewallRule get(String firewallRuleId) {
        Preconditions.checkNotNull(firewallRuleId);
        return this.get(NeutronFirewallRule.class, this.uri("/fw/firewall_rules/%s", firewallRuleId)).execute();
    }

    @Override
    public ActionResponse delete(String firewallRuleId) {
        Preconditions.checkNotNull(firewallRuleId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/fw/firewall_rules/%s", firewallRuleId)).executeWithResponse());
    }

    @Override
    public FirewallRule create(FirewallRule firewall) {
        return this.post(NeutronFirewallRule.class, this.uri("/fw/firewall_rules", new Object[0])).entity(firewall).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }

    @Override
    public FirewallRule update(String firewallRuleId, FirewallRuleUpdate firewallRuleUpdate) {
        Preconditions.checkNotNull(firewallRuleId);
        Preconditions.checkNotNull(firewallRuleUpdate);
        return this.put(NeutronFirewallRule.class, this.uri("/fw/firewall_rules/%s", firewallRuleId)).entity(firewallRuleUpdate).execute();
    }
}

