/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.internal.ext;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.openstack4j.api.networking.ext.LbPoolV2Service;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.ext.LbPoolV2;
import org.openstack4j.model.network.ext.LbPoolV2Update;
import org.openstack4j.model.network.ext.MemberV2;
import org.openstack4j.model.network.ext.MemberV2Update;
import org.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.networking.domain.ext.NeutronLbPoolV2;
import org.openstack4j.openstack.networking.domain.ext.NeutronMemberV2;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class LbPoolV2ServiceImpl
extends BaseNetworkingServices
implements LbPoolV2Service {
    @Override
    public List<? extends LbPoolV2> list() {
        return this.get(NeutronLbPoolV2.LbPoolsV2.class, this.uri("/lbaas/pools", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends LbPoolV2> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<NeutronLbPoolV2.LbPoolsV2> req = this.get(NeutronLbPoolV2.LbPoolsV2.class, this.uri("/lbaas/pools", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public LbPoolV2 get(String lbPoolId) {
        Preconditions.checkNotNull(lbPoolId);
        return this.get(NeutronLbPoolV2.class, this.uri("/lbaas/pools/%s", lbPoolId)).execute();
    }

    @Override
    public LbPoolV2 create(LbPoolV2 lbPool) {
        Preconditions.checkNotNull(lbPool);
        return this.post(NeutronLbPoolV2.class, this.uri("/lbaas/pools", new Object[0])).entity(lbPool).execute();
    }

    @Override
    public LbPoolV2 update(String lbPoolId, LbPoolV2Update lbPool) {
        Preconditions.checkNotNull(lbPoolId);
        Preconditions.checkNotNull(lbPool);
        return this.put(NeutronLbPoolV2.class, this.uri("/lbaas/pools/%s", lbPoolId)).entity(lbPool).execute();
    }

    @Override
    public ActionResponse delete(String lbPoolId) {
        Preconditions.checkNotNull(lbPoolId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.TYPE, this.uri("/lbaas/pools/%s", lbPoolId)).executeWithResponse());
    }

    @Override
    public List<? extends MemberV2> listMembers(String lbPoolId) {
        return this.get(NeutronMemberV2.MembersV2.class, this.uri("/lbaas/pools/%s/members", lbPoolId)).execute().getList();
    }

    @Override
    public List<? extends MemberV2> listMembers(String lbPoolId, Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<NeutronMemberV2.MembersV2> req = this.get(NeutronMemberV2.MembersV2.class, this.uri("/lbaas/pools/%s/members", lbPoolId));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public MemberV2 getMember(String lbPoolId, String memberId) {
        Preconditions.checkNotNull(lbPoolId);
        Preconditions.checkNotNull(memberId);
        return this.get(NeutronMemberV2.class, this.uri("/lbaas/pools/%s/members/%s", lbPoolId, memberId)).execute();
    }

    @Override
    public MemberV2 createMember(String lbPoolId, MemberV2 member) {
        Preconditions.checkNotNull(lbPoolId);
        Preconditions.checkNotNull(member);
        return this.post(NeutronMemberV2.class, this.uri("/lbaas/pools/%s/members", lbPoolId)).entity(member).execute();
    }

    @Override
    public MemberV2 updateMember(String lbPoolId, String memberId, MemberV2Update member) {
        Preconditions.checkNotNull(lbPoolId);
        Preconditions.checkNotNull(memberId);
        Preconditions.checkNotNull(member);
        return this.put(NeutronMemberV2.class, this.uri("/lbaas/pools/%s/members/%s", lbPoolId, memberId)).entity(member).execute();
    }

    @Override
    public ActionResponse deleteMember(String lbPoolId, String memberId) {
        Preconditions.checkNotNull(lbPoolId);
        Preconditions.checkNotNull(memberId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.TYPE, this.uri("/lbaas/pools/%s/members/%s", lbPoolId, memberId)).executeWithResponse());
    }
}

