/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.internal.ext;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.networking.ext.NetQuotaService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.NetQuota;
import org.openstack4j.openstack.networking.domain.NeutronNetQuota;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class NetQuotaServiceImpl
extends BaseNetworkingServices
implements NetQuotaService {
    @Override
    public List<? extends NetQuota> get() {
        return this.get(NeutronNetQuota.NeutronNetQuotas.class, this.uri("/quotas", new Object[0])).execute().getList();
    }

    @Override
    public NetQuota get(String tenantId) {
        Preconditions.checkNotNull(tenantId, "TenantId must not be null");
        return this.get(NeutronNetQuota.class, this.uri("/quotas/%s", tenantId)).execute();
    }

    @Override
    public NetQuota updateForTenant(String tenantId, NetQuota netQuota) {
        Preconditions.checkNotNull(tenantId, "TenantId must not be null");
        Preconditions.checkNotNull(netQuota, "NetQuota must not be null");
        return this.put(NeutronNetQuota.class, this.uri("/quotas/%s", tenantId)).entity(netQuota).execute();
    }

    @Override
    public NetQuota update(NetQuota netQuota) {
        Preconditions.checkNotNull(netQuota, "NetQuota must not be null");
        return this.put(NeutronNetQuota.class, this.uri("/quotas", new Object[0])).entity(netQuota).execute();
    }

    @Override
    public ActionResponse reset() {
        return this.deleteWithResponse(this.uri("/quotas", new Object[0])).execute();
    }

    @Override
    public ActionResponse reset(String tenantId) {
        Preconditions.checkNotNull(tenantId, "TenantId must not be null");
        return this.deleteWithResponse(this.uri("/quotas/%s", tenantId)).execute();
    }
}

