/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.sahara.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.Objects;
import java.util.Date;
import java.util.List;
import org.openstack4j.model.sahara.JobConfig;
import org.openstack4j.model.sahara.JobExecution;
import org.openstack4j.model.sahara.JobExecutionInfo;
import org.openstack4j.model.sahara.builder.JobExecutionBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.sahara.domain.SaharaJobConfig;
import org.openstack4j.openstack.sahara.domain.SaharaJobExecutionInfo;

@JsonRootName(value="job_execution")
@JsonIgnoreProperties(value={"jobIdForExecution"}, ignoreUnknown=true)
public class SaharaJobExecution
implements JobExecution {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="cluster_id")
    private String clusterId;
    @JsonProperty(value="input_id")
    private String inputId;
    @JsonProperty(value="output_id")
    private String outputId;
    @JsonProperty(value="job_configs")
    private SaharaJobConfig jobConfigs;
    @JsonProperty(value="job_id")
    private String jobId;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    @JsonProperty(value="start_time")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss")
    private Date startTime;
    @JsonProperty(value="end_time")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss")
    private Date endTime;
    @JsonProperty(value="created_at")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date createdAt;
    @JsonProperty(value="updated_at")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date updatedAt;
    @JsonProperty(value="oozie_job_id")
    private String oozieJobId;
    @JsonProperty(value="return_code")
    private String returnCode;
    @JsonProperty(value="progress")
    private String progress;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="info")
    private SaharaJobExecutionInfo info;
    private String jobIdForExecute;

    @Override
    public String getJobIdForExecution() {
        return this.jobIdForExecute;
    }

    @Override
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    public String getInputId() {
        return this.inputId;
    }

    @Override
    public String getOutputId() {
        return this.outputId;
    }

    @Override
    public JobConfig getJobConfigs() {
        return this.jobConfigs;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    @Override
    public Date getEndtime() {
        return this.endTime;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    public String getReturnCode() {
        return this.returnCode;
    }

    @Override
    public String getOozieJobId() {
        return this.oozieJobId;
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getProgress() {
        return this.progress;
    }

    @Override
    public JobExecutionInfo getInfo() {
        return this.info;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("cluster_id", (Object)this.clusterId).add("input_id", (Object)this.inputId).add("output_id", (Object)this.outputId).add("job_configs", (Object)this.jobConfigs).add("job_id", (Object)this.jobId).add("tenant_id", (Object)this.tenantId).add("start_time", (Object)this.startTime).add("end_time", (Object)this.endTime).add("created_at", (Object)this.createdAt).add("updated_at", (Object)this.updatedAt).add("oozie_job_id", (Object)this.oozieJobId).add("return_code", (Object)this.returnCode).add("progress", (Object)this.progress).add("info", (Object)this.info).add("id", (Object)this.id).toString();
    }

    @Override
    public JobExecutionBuilder toBuilder() {
        return new concreteJobExecutionBuilder(this);
    }

    public static JobExecutionBuilder builder() {
        return new concreteJobExecutionBuilder();
    }

    public static class concreteJobExecutionBuilder
    implements JobExecutionBuilder {
        SaharaJobExecution m;

        concreteJobExecutionBuilder() {
            this(new SaharaJobExecution());
        }

        concreteJobExecutionBuilder(SaharaJobExecution m4) {
            this.m = m4;
        }

        @Override
        public JobExecution build() {
            return this.m;
        }

        @Override
        public JobExecutionBuilder from(JobExecution in) {
            this.m = (SaharaJobExecution)in;
            return this;
        }

        @Override
        public JobExecutionBuilder clusterId(String clusterId) {
            this.m.clusterId = clusterId;
            return this;
        }

        @Override
        public JobExecutionBuilder inputId(String inputId) {
            this.m.inputId = inputId;
            return this;
        }

        @Override
        public JobExecutionBuilder outputId(String outputId) {
            this.m.outputId = outputId;
            return this;
        }

        @Override
        public JobExecutionBuilder setJobConfig(JobConfig jobConfig) {
            this.m.jobConfigs = (SaharaJobConfig)jobConfig;
            return this;
        }

        @Override
        public JobExecutionBuilder jobId(String jobId) {
            this.m.jobIdForExecute = jobId;
            return this;
        }
    }

    public static class JobExecutions
    extends ListResult<SaharaJobExecution> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="job_executions")
        private List<SaharaJobExecution> jobExecutions;

        @Override
        public List<SaharaJobExecution> value() {
            return this.jobExecutions;
        }
    }
}

