/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.storage.block.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.openstack4j.api.Builders;
import org.openstack4j.api.storage.BlockVolumeSnapshotService;
import org.openstack4j.model.ModelEntity;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.storage.block.VolumeSnapshot;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.storage.block.domain.CinderVolumeSnapshot;
import org.openstack4j.openstack.storage.block.internal.BaseBlockStorageServices;

public class BlockVolumeSnapshotServiceImpl
extends BaseBlockStorageServices
implements BlockVolumeSnapshotService {
    @Override
    public List<? extends VolumeSnapshot> list() {
        return this.get(CinderVolumeSnapshot.VolumeSnapshots.class, this.uri("/snapshots", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends VolumeSnapshot> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<CinderVolumeSnapshot.VolumeSnapshots> volumeInvocation = this.buildInvocation(filteringParams);
        return volumeInvocation.execute().getList();
    }

    @Override
    public VolumeSnapshot get(String snapshotId) {
        Preconditions.checkNotNull(snapshotId);
        return this.get(CinderVolumeSnapshot.class, this.uri("/snapshots/%s", snapshotId)).execute();
    }

    @Override
    public ActionResponse delete(String snapshotId) {
        Preconditions.checkNotNull(snapshotId);
        return this.deleteWithResponse(this.uri("/snapshots/%s", snapshotId)).execute();
    }

    @Override
    public ActionResponse update(String snapshotId, String name, String description) {
        Preconditions.checkNotNull(snapshotId);
        if (name == null && description == null) {
            return ActionResponse.actionFailed("Both Name and Description are required", 412);
        }
        return this.put(ActionResponse.class, this.uri("/snapshots/%s", snapshotId)).entity((ModelEntity)Builders.volumeSnapshot().name(name).description(description).build()).execute();
    }

    @Override
    public VolumeSnapshot create(VolumeSnapshot snapshot) {
        Preconditions.checkNotNull(snapshot);
        Preconditions.checkNotNull(snapshot.getVolumeId());
        return this.post(CinderVolumeSnapshot.class, this.uri("/snapshots", new Object[0])).entity(snapshot).execute();
    }

    private BaseOpenStackService.Invocation<CinderVolumeSnapshot.VolumeSnapshots> buildInvocation(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<CinderVolumeSnapshot.VolumeSnapshots> volumeInvocation = this.get(CinderVolumeSnapshot.VolumeSnapshots.class, "/snapshots");
        if (filteringParams == null) {
            return volumeInvocation;
        }
        for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
            volumeInvocation = volumeInvocation.param(entry.getKey(), entry.getValue());
        }
        return volumeInvocation;
    }
}

