/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.telemetry.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.telemetry.SampleService;
import org.openstack4j.model.telemetry.Sample;
import org.openstack4j.model.telemetry.SampleCriteria;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.telemetry.domain.CeiloMeterSample;
import org.openstack4j.openstack.telemetry.internal.BaseTelemetryServices;

public class SampleServiceImpl
extends BaseTelemetryServices
implements SampleService {
    private static final String FIELD = "q.field";
    private static final String OPER = "q.op";
    private static final String VALUE = "q.value";

    @Override
    public List<? extends Sample> list() {
        CeiloMeterSample[] samples = this.get(CeiloMeterSample[].class, this.uri("/samples", new Object[0])).execute();
        return this.wrapList(samples);
    }

    @Override
    public List<? extends Sample> list(SampleCriteria criteria) {
        BaseOpenStackService.Invocation<CeiloMeterSample[]> invocation = this.get(CeiloMeterSample[].class, this.uri("/samples", new Object[0]));
        if (criteria != null && !criteria.getCriteriaParams().isEmpty()) {
            for (SampleCriteria.NameOpValue c : criteria.getCriteriaParams()) {
                invocation.param(FIELD, c.getField());
                invocation.param(OPER, c.getOperator().getQueryValue());
                invocation.param(VALUE, c.getValue());
            }
        }
        CeiloMeterSample[] samples = invocation.execute();
        return this.wrapList(samples);
    }

    @Override
    public Sample get(String sampleId) {
        Preconditions.checkNotNull(sampleId);
        CeiloMeterSample sample = this.get(CeiloMeterSample.class, this.uri("/samples/%s", sampleId)).execute();
        return sample;
    }
}

