/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openstack.glance;

import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.openstack.common.AbstractOpenstackProducer;
import org.apache.camel.component.openstack.glance.GlanceEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.openstack4j.api.Builders;
import org.openstack4j.api.OSClient;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.common.Payload;
import org.openstack4j.model.image.ContainerFormat;
import org.openstack4j.model.image.DiskFormat;
import org.openstack4j.model.image.Image;
import org.openstack4j.model.image.builder.ImageBuilder;

public class GlanceProducer
extends AbstractOpenstackProducer {
    public GlanceProducer(GlanceEndpoint endpoint, OSClient client) {
        super(endpoint, client);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = this.getOperation(exchange)) {
            case "reserve": {
                this.doReserve(exchange);
                break;
            }
            case "create": {
                this.doCreate(exchange);
                break;
            }
            case "update": {
                this.doUpdate(exchange);
                break;
            }
            case "upload": {
                this.doUpload(exchange);
                break;
            }
            case "get": {
                this.doGet(exchange);
                break;
            }
            case "getAll": {
                this.doGetAll(exchange);
                break;
            }
            case "delete": {
                this.doDelete(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    private void doReserve(Exchange exchange) {
        Image in = this.messageToImage(exchange.getIn());
        Image out = this.os.images().reserve(in);
        exchange.getIn().setBody(out);
    }

    private void doCreate(Exchange exchange) {
        Message msg = exchange.getIn();
        Image in = this.messageHeadersToImage(msg, true);
        Payload payload = this.createPayload(msg);
        Image out = this.os.images().create(in, payload);
        msg.setBody(out);
    }

    private void doUpload(Exchange exchange) {
        Message msg = exchange.getIn();
        String imageId = msg.getHeader("ID", String.class);
        StringHelper.notEmpty(imageId, "Image ID");
        Image in = this.messageHeadersToImage(msg, false);
        Payload payload = this.createPayload(msg);
        Image out = this.os.images().upload(imageId, payload, in);
        msg.setBody(out);
    }

    private void doUpdate(Exchange exchange) {
        Message msg = exchange.getIn();
        Image in = this.messageToImage(msg);
        Image out = this.os.images().update(in);
        msg.setBody(out);
    }

    private void doGet(Exchange exchange) {
        Message msg = exchange.getIn();
        String imageId = msg.getHeader("ID", String.class);
        StringHelper.notEmpty(imageId, "ImageID");
        Image out = this.os.images().get(imageId);
        msg.setBody(out);
    }

    private void doGetAll(Exchange exchange) {
        List<? extends Image> out = this.os.images().list();
        exchange.getIn().setBody(out);
    }

    private void doDelete(Exchange exchange) {
        Message msg = exchange.getIn();
        String imageId = msg.getHeader("ID", String.class);
        StringHelper.notEmpty(imageId, "ImageID");
        ActionResponse response = this.os.compute().images().delete(imageId);
        this.checkFailure(response, exchange, "Delete image " + imageId);
    }

    private Image messageToImage(Message message) {
        Image image = message.getBody(Image.class);
        if (image == null) {
            image = this.messageHeadersToImage(message, true);
        }
        return image;
    }

    private Image messageHeadersToImage(Message message, boolean required) {
        ImageBuilder imageBuilder = null;
        if (required && ObjectHelper.isEmpty(message.getHeader("name", String.class))) {
            throw new IllegalArgumentException("Image Name must be specified and not empty");
        }
        if (ObjectHelper.isNotEmpty(message.getHeader("name", String.class))) {
            imageBuilder = this.getImageBuilder(imageBuilder).name(message.getHeader("name", String.class));
        }
        if (ObjectHelper.isNotEmpty(message.getHeader("diskFormat", DiskFormat.class))) {
            imageBuilder = this.getImageBuilder(imageBuilder).diskFormat(message.getHeader("diskFormat", DiskFormat.class));
        }
        if (ObjectHelper.isNotEmpty(message.getHeader("containerFormat", ContainerFormat.class))) {
            imageBuilder = this.getImageBuilder(imageBuilder).containerFormat(message.getHeader("containerFormat", ContainerFormat.class));
        }
        if (ObjectHelper.isNotEmpty(message.getHeader("size", Long.class))) {
            imageBuilder = this.getImageBuilder(imageBuilder).size(message.getHeader("size", Long.class));
        }
        if (ObjectHelper.isNotEmpty(message.getHeader("checksum"))) {
            imageBuilder = this.getImageBuilder(imageBuilder).checksum(message.getHeader("checksum", String.class));
        }
        if (ObjectHelper.isNotEmpty(message.getHeader("minDisk"))) {
            imageBuilder = this.getImageBuilder(imageBuilder).minDisk(message.getHeader("minDisk", Long.class));
        }
        if (ObjectHelper.isNotEmpty(message.getHeader("minRam"))) {
            imageBuilder = this.getImageBuilder(imageBuilder).minRam(message.getHeader("minRam", Long.class));
        }
        if (ObjectHelper.isNotEmpty(message.getHeader("owner"))) {
            imageBuilder = this.getImageBuilder(imageBuilder).owner(message.getHeader("owner", String.class));
        }
        if (ObjectHelper.isNotEmpty(message.getHeader("isPublic"))) {
            imageBuilder = this.getImageBuilder(imageBuilder).isPublic(message.getHeader("isPublic", Boolean.class));
        }
        if (ObjectHelper.isNotEmpty(message.getHeader("properties"))) {
            imageBuilder = this.getImageBuilder(imageBuilder).properties(message.getHeader("properties", Map.class));
        }
        if (!required && imageBuilder == null) {
            return null;
        }
        ObjectHelper.notNull(imageBuilder, "Image");
        return (Image)imageBuilder.build();
    }

    private ImageBuilder getImageBuilder(ImageBuilder builder) {
        return builder == null ? Builders.image() : builder;
    }
}

