/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openstack.keystone.producer;

import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.openstack.keystone.KeystoneEndpoint;
import org.apache.camel.component.openstack.keystone.producer.AbstractKeystoneProducer;
import org.apache.camel.util.StringHelper;
import org.openstack4j.api.Builders;
import org.openstack4j.api.OSClient;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.identity.v3.Domain;
import org.openstack4j.model.identity.v3.builder.DomainBuilder;

public class DomainProducer
extends AbstractKeystoneProducer {
    public DomainProducer(KeystoneEndpoint endpoint, OSClient client) {
        super(endpoint, client);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = this.getOperation(exchange)) {
            case "create": {
                this.doCreate(exchange);
                break;
            }
            case "get": {
                this.doGet(exchange);
                break;
            }
            case "getAll": {
                this.doGetAll(exchange);
                break;
            }
            case "update": {
                this.doUpdate(exchange);
                break;
            }
            case "delete": {
                this.doDelete(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    private void doCreate(Exchange exchange) {
        Domain in = this.messageToDomain(exchange.getIn());
        Domain out = this.osV3Client.identity().domains().create(in);
        exchange.getIn().setBody(out);
    }

    private void doGet(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = msg.getHeader("ID", msg.getHeader("domainId", String.class), String.class);
        StringHelper.notEmpty(id, "Domain ID");
        Domain out = this.osV3Client.identity().domains().get(id);
        exchange.getIn().setBody(out);
    }

    private void doGetAll(Exchange exchange) {
        List<? extends Domain> out = this.osV3Client.identity().domains().list();
        exchange.getIn().setBody(out);
    }

    private void doUpdate(Exchange exchange) {
        Message msg = exchange.getIn();
        Domain in = this.messageToDomain(msg);
        Domain out = this.osV3Client.identity().domains().update(in);
        msg.setBody(out);
    }

    private void doDelete(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = msg.getHeader("ID", msg.getHeader("domainId", String.class), String.class);
        StringHelper.notEmpty(id, "Domain ID");
        ActionResponse response = this.osV3Client.identity().domains().delete(id);
        this.checkFailure(response, exchange, "Delete domain" + id);
    }

    private Domain messageToDomain(Message message) {
        Domain domain = message.getBody(Domain.class);
        if (domain == null) {
            Map<String, Object> headers = message.getHeaders();
            DomainBuilder builder = Builders.domain();
            StringHelper.notEmpty(message.getHeader("name", String.class), "Name");
            builder.name(message.getHeader("name", String.class));
            if (headers.containsKey("description")) {
                builder.description(message.getHeader("description", String.class));
            }
            domain = (Domain)builder.build();
        }
        return domain;
    }
}

