/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openstack.keystone.producer;

import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.openstack.keystone.KeystoneEndpoint;
import org.apache.camel.component.openstack.keystone.producer.AbstractKeystoneProducer;
import org.apache.camel.util.StringHelper;
import org.openstack4j.api.Builders;
import org.openstack4j.api.OSClient;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.identity.v3.Group;
import org.openstack4j.model.identity.v3.builder.GroupBuilder;

public class GroupProducer
extends AbstractKeystoneProducer {
    public GroupProducer(KeystoneEndpoint endpoint, OSClient client) {
        super(endpoint, client);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = this.getOperation(exchange)) {
            case "create": {
                this.doCreate(exchange);
                break;
            }
            case "get": {
                this.doGet(exchange);
                break;
            }
            case "getAll": {
                this.doGetAll(exchange);
                break;
            }
            case "update": {
                this.doUpdate(exchange);
                break;
            }
            case "delete": {
                this.doDelete(exchange);
                break;
            }
            case "addUserToGroup": {
                this.doAddUser(exchange);
                break;
            }
            case "checkUserGroup": {
                this.doCheckUserGroup(exchange);
                break;
            }
            case "removeUserFromGroup": {
                this.doRemoveUserFromGroup(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    private void doCreate(Exchange exchange) {
        Group in = this.messageToGroup(exchange.getIn());
        Group out = this.osV3Client.identity().groups().create(in);
        exchange.getIn().setBody(out);
    }

    private void doGet(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = msg.getHeader("ID", msg.getHeader("groupId", String.class), String.class);
        StringHelper.notEmpty(id, "Group ID");
        Group result = this.osV3Client.identity().groups().get(id);
        msg.setBody(result);
    }

    private void doGetAll(Exchange exchange) {
        List<? extends Group> out = this.osV3Client.identity().groups().list();
        exchange.getIn().setBody(out);
    }

    private void doUpdate(Exchange exchange) {
        Message msg = exchange.getIn();
        Group group = this.messageToGroup(msg);
        Group updatedGroup = this.osV3Client.identity().groups().update(group);
        msg.setBody(updatedGroup);
    }

    private void doDelete(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = msg.getHeader("ID", msg.getHeader("groupId", String.class), String.class);
        StringHelper.notEmpty(id, "Group ID");
        ActionResponse response = this.osV3Client.identity().groups().delete(id);
        this.checkFailure(response, exchange, "Delete group with ID " + id);
    }

    private void doAddUser(Exchange exchange) {
        Message msg = exchange.getIn();
        String userId = msg.getHeader("userId", String.class);
        String groupId = msg.getHeader("groupId", String.class);
        StringHelper.notEmpty(userId, "User ID");
        StringHelper.notEmpty(groupId, "Group ID");
        ActionResponse response = this.osV3Client.identity().groups().addUserToGroup(groupId, userId);
        this.checkFailure(response, exchange, String.format("Add user %s to group %s", userId, groupId));
    }

    private void doCheckUserGroup(Exchange exchange) {
        Message msg = exchange.getIn();
        String userId = msg.getHeader("userId", String.class);
        String groupId = msg.getHeader("groupId", String.class);
        StringHelper.notEmpty(userId, "User ID");
        StringHelper.notEmpty(groupId, "Group ID");
        ActionResponse response = this.osV3Client.identity().groups().checkGroupUser(groupId, userId);
        msg.setBody(response.isSuccess());
    }

    private void doRemoveUserFromGroup(Exchange exchange) {
        Message msg = exchange.getIn();
        String userId = msg.getHeader("userId", String.class);
        String groupId = msg.getHeader("groupId", String.class);
        StringHelper.notEmpty(userId, "User ID");
        StringHelper.notEmpty(groupId, "Group ID");
        ActionResponse response = this.osV3Client.identity().groups().removeUserFromGroup(groupId, userId);
        this.checkFailure(response, exchange, String.format("Delete user %s from group %s", userId, groupId));
    }

    private Group messageToGroup(Message message) {
        Group group = message.getBody(Group.class);
        if (group == null) {
            Map<String, Object> headers = message.getHeaders();
            GroupBuilder builder = Builders.group();
            StringHelper.notEmpty(message.getHeader("name", String.class), "Name");
            builder.name(message.getHeader("name", String.class));
            if (headers.containsKey("domainId")) {
                builder.domainId(message.getHeader("domainId", String.class));
            }
            if (headers.containsKey("description")) {
                builder.description(message.getHeader("description", String.class));
            }
            group = (Group)builder.build();
        }
        return group;
    }
}

