/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openstack.neutron.producer;

import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.openstack.common.AbstractOpenstackProducer;
import org.apache.camel.component.openstack.neutron.NeutronEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.openstack4j.api.Builders;
import org.openstack4j.api.OSClient;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.IPVersionType;
import org.openstack4j.model.network.Subnet;
import org.openstack4j.model.network.builder.SubnetBuilder;
import org.openstack4j.openstack.networking.domain.NeutronPool;

public class SubnetProducer
extends AbstractOpenstackProducer {
    public SubnetProducer(NeutronEndpoint endpoint, OSClient client) {
        super(endpoint, client);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = this.getOperation(exchange)) {
            case "create": {
                this.doCreate(exchange);
                break;
            }
            case "get": {
                this.doGet(exchange);
                break;
            }
            case "getAll": {
                this.doGetAll(exchange);
                break;
            }
            case "delete": {
                this.doDelete(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    private void doCreate(Exchange exchange) {
        Subnet in = this.messageToSubnet(exchange.getIn());
        Subnet out = this.os.networking().subnet().create(in);
        exchange.getIn().setBody(out);
    }

    private void doGet(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = msg.getHeader("ID", msg.getHeader("subnetId", String.class), String.class);
        StringHelper.notEmpty(id, "Subnet ID");
        Subnet out = this.os.networking().subnet().get(id);
        exchange.getIn().setBody(out);
    }

    private void doGetAll(Exchange exchange) {
        List<? extends Subnet> out = this.os.networking().subnet().list();
        exchange.getIn().setBody(out);
    }

    private void doDelete(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = msg.getHeader("ID", msg.getHeader("subnetId", String.class), String.class);
        StringHelper.notEmpty(id, "Subnet ID");
        ActionResponse response = this.os.networking().subnet().delete(id);
        this.checkFailure(response, exchange, "Delete network " + id);
    }

    private Subnet messageToSubnet(Message message) {
        Subnet subnet = message.getBody(Subnet.class);
        if (subnet == null) {
            Map<String, Object> headers = message.getHeaders();
            SubnetBuilder builder = Builders.subnet();
            StringHelper.notEmpty(message.getHeader("name", String.class), "Name");
            builder.name(message.getHeader("name", String.class));
            StringHelper.notEmpty(message.getHeader("networkId", String.class), "Network ID");
            builder.networkId(message.getHeader("networkId", String.class));
            ObjectHelper.notNull(message.getHeader("ipVersion", IPVersionType.class), "IP version");
            builder.ipVersion(message.getHeader("ipVersion", IPVersionType.class));
            if (headers.containsKey("cidr")) {
                builder.cidr(message.getHeader("cidr", String.class));
            }
            if (headers.containsKey("subnetPools")) {
                NeutronPool pool = message.getHeader("subnetPools", NeutronPool.class);
                builder.addPool(pool.getStart(), pool.getEnd());
            }
            if (headers.containsKey("networkId")) {
                builder.networkId(message.getHeader("networkId", String.class));
            }
            if (headers.containsKey("enableDHCP")) {
                builder.enableDHCP(message.getHeader("enableDHCP", Boolean.class));
            }
            if (headers.containsKey("gateway")) {
                builder.gateway(message.getHeader("gateway", String.class));
            }
            subnet = (Subnet)builder.build();
        }
        return subnet;
    }
}

