/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openstack.nova.producer;

import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.openstack.common.AbstractOpenstackProducer;
import org.apache.camel.component.openstack.nova.NovaEndpoint;
import org.apache.camel.util.StringHelper;
import org.openstack4j.api.Builders;
import org.openstack4j.api.OSClient;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.compute.Flavor;
import org.openstack4j.model.compute.builder.FlavorBuilder;

public class FlavorsProducer
extends AbstractOpenstackProducer {
    public FlavorsProducer(NovaEndpoint endpoint, OSClient client) {
        super(endpoint, client);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = this.getOperation(exchange)) {
            case "create": {
                this.doCreate(exchange);
                break;
            }
            case "get": {
                this.doGet(exchange);
                break;
            }
            case "getAll": {
                this.doGetAll(exchange);
                break;
            }
            case "delete": {
                this.doDelete(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    private void doCreate(Exchange exchange) {
        Flavor in = this.messageToFlavor(exchange.getIn());
        Flavor out = this.os.compute().flavors().create(in);
        exchange.getIn().setBody(out);
    }

    private void doGet(Exchange exchange) {
        Message msg = exchange.getIn();
        String flavorId = msg.getHeader("ID", msg.getHeader("FlavorId", String.class), String.class);
        StringHelper.notEmpty(flavorId, "FlavorID");
        Flavor out = this.os.compute().flavors().get(flavorId);
        exchange.getIn().setBody(out);
    }

    private void doGetAll(Exchange exchange) {
        List<? extends Flavor> out = this.os.compute().flavors().list();
        exchange.getIn().setBody(out);
    }

    private void doDelete(Exchange exchange) {
        Message msg = exchange.getIn();
        String flavorId = msg.getHeader("ID", msg.getHeader("FlavorId", String.class), String.class);
        StringHelper.notEmpty(flavorId, "FlavorID");
        ActionResponse response = this.os.compute().flavors().delete(flavorId);
        this.checkFailure(response, exchange, "Delete flavor");
    }

    private Flavor messageToFlavor(Message message) {
        Flavor flavor = message.getBody(Flavor.class);
        if (flavor == null) {
            Map<String, Object> headers = message.getHeaders();
            FlavorBuilder flavorBuilder = Builders.flavor();
            StringHelper.notEmpty(message.getHeader("name", String.class), "Name");
            flavorBuilder.name(message.getHeader("name", String.class));
            if (headers.containsKey("VCPU")) {
                flavorBuilder.vcpus(message.getHeader("VCPU", Integer.class));
            }
            if (headers.containsKey("RAM")) {
                flavorBuilder.ram(message.getHeader("RAM", Integer.class));
            }
            if (headers.containsKey("disk")) {
                flavorBuilder.disk(message.getHeader("disk", Integer.class));
            }
            if (headers.containsKey("swap")) {
                flavorBuilder.swap(message.getHeader("swap", Integer.class));
            }
            if (headers.containsKey("rxtxFactor")) {
                flavorBuilder.rxtxFactor(message.getHeader("rxtxFactor", Integer.class).intValue());
            }
            flavor = (Flavor)flavorBuilder.build();
        }
        return flavor;
    }
}

