/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openstack.swift.producer;

import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.openstack.common.AbstractOpenstackProducer;
import org.apache.camel.component.openstack.common.OpenstackException;
import org.apache.camel.component.openstack.swift.SwiftEndpoint;
import org.apache.camel.util.StringHelper;
import org.openstack4j.api.OSClient;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.storage.object.SwiftContainer;
import org.openstack4j.model.storage.object.options.ContainerListOptions;
import org.openstack4j.model.storage.object.options.CreateUpdateContainerOptions;

public class ContainerProducer
extends AbstractOpenstackProducer {
    public ContainerProducer(SwiftEndpoint endpoint, OSClient client) {
        super(endpoint, client);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = this.getOperation(exchange)) {
            case "create": {
                this.doCreate(exchange);
                break;
            }
            case "get": {
                this.doGet(exchange);
                break;
            }
            case "getAll": {
                this.doGetAll(exchange);
                break;
            }
            case "update": {
                this.doUpdate(exchange);
                break;
            }
            case "delete": {
                this.doDelete(exchange);
                break;
            }
            case "getMetadata": {
                this.doGetMetadata(exchange);
                break;
            }
            case "createUpdateMetadata": {
                this.doUpdateMetadata(exchange);
                break;
            }
            case "deleteMetadata": {
                this.doDeleteMetadata(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    private void doCreate(Exchange exchange) {
        Message msg = exchange.getIn();
        String name = msg.getHeader("name", msg.getHeader("containerName", String.class), String.class);
        StringHelper.notEmpty(name, "Container name");
        CreateUpdateContainerOptions options = this.messageToCreateUpdateOptions(msg);
        ActionResponse out = this.os.objectStorage().containers().create(name, options);
        this.checkFailure(out, exchange, "Create container " + name);
    }

    private void doGet(Exchange exchange) {
        Message msg = exchange.getIn();
        ContainerListOptions options = this.messageToListOptions(msg);
        List<? extends SwiftContainer> out = this.os.objectStorage().containers().list(options);
        msg.setBody(out);
    }

    private void doGetAll(Exchange exchange) {
        Message msg = exchange.getIn();
        List<? extends SwiftContainer> out = this.os.objectStorage().containers().list();
        msg.setBody(out);
    }

    private void doUpdate(Exchange exchange) {
        Message msg = exchange.getIn();
        String name = msg.getHeader("name", msg.getHeader("containerName", String.class), String.class);
        StringHelper.notEmpty(name, "Container name");
        CreateUpdateContainerOptions options = this.messageToCreateUpdateOptions(msg);
        ActionResponse out = this.os.objectStorage().containers().update(name, options);
        this.checkFailure(out, exchange, "Update container " + name);
    }

    private void doDelete(Exchange exchange) {
        Message msg = exchange.getIn();
        String name = msg.getHeader("name", msg.getHeader("containerName", String.class), String.class);
        StringHelper.notEmpty(name, "Container name");
        ActionResponse out = this.os.objectStorage().containers().delete(name);
        this.checkFailure(out, exchange, "Delete container " + name);
    }

    private void doGetMetadata(Exchange exchange) {
        Message msg = exchange.getIn();
        String name = msg.getHeader("name", msg.getHeader("containerName", String.class), String.class);
        StringHelper.notEmpty(name, "Container name");
        msg.setBody(this.os.objectStorage().containers().getMetadata(name));
    }

    private void doDeleteMetadata(Exchange exchange) {
        Message msg = exchange.getIn();
        String name = msg.getHeader("name", msg.getHeader("containerName", String.class), String.class);
        StringHelper.notEmpty(name, "Container name");
        boolean success = this.os.objectStorage().containers().deleteMetadata(name, msg.getBody(Map.class));
        if (!success) {
            exchange.setException(new OpenstackException("Removing metadata was not successful"));
        }
    }

    private void doUpdateMetadata(Exchange exchange) {
        Message msg = exchange.getIn();
        String name = msg.getHeader("name", msg.getHeader("containerName", String.class), String.class);
        StringHelper.notEmpty(name, "Container name");
        boolean success = this.os.objectStorage().containers().updateMetadata(name, msg.getBody(Map.class));
        if (!success) {
            exchange.setException(new OpenstackException("Updating metadata was not successful"));
        }
    }

    private CreateUpdateContainerOptions messageToCreateUpdateOptions(Message message) {
        CreateUpdateContainerOptions options = message.getBody(CreateUpdateContainerOptions.class);
        if (options == null) {
            Map<String, Object> headers = message.getHeaders();
            if (headers.containsKey("X-Container-Meta-")) {
                options = this.getCreateUpdateOptions(options).metadata(message.getHeader("X-Container-Meta-", Map.class));
            }
            if (headers.containsKey("X-Versions-Location")) {
                options = this.getCreateUpdateOptions(options).versionsLocation(message.getHeader("X-Versions-Location", String.class));
            }
            if (headers.containsKey("X-Container-Read")) {
                options = this.getCreateUpdateOptions(options).accessRead(message.getHeader("X-Container-Read", String.class));
            }
            if (headers.containsKey("X-Container-Write")) {
                options = this.getCreateUpdateOptions(options).accessWrite(message.getHeader("X-Container-Write", String.class));
            }
        }
        return options;
    }

    private CreateUpdateContainerOptions getCreateUpdateOptions(CreateUpdateContainerOptions options) {
        return options == null ? CreateUpdateContainerOptions.create() : options;
    }

    private ContainerListOptions messageToListOptions(Message message) {
        ContainerListOptions options = message.getBody(ContainerListOptions.class);
        if (options == null) {
            Map<String, Object> headers = message.getHeaders();
            if (headers.containsKey("limit")) {
                options = this.getListOptions(options).limit(message.getHeader("limit", Integer.class));
            }
            if (headers.containsKey("marker")) {
                options = this.getListOptions(options).marker(message.getHeader("marker", String.class));
            }
            if (headers.containsKey("end_marker")) {
                options = this.getListOptions(options).endMarker(message.getHeader("end_marker", String.class));
            }
            if (headers.containsKey("delimiter")) {
                options = this.getListOptions(options).delimiter(message.getHeader("delimiter", Character.class).charValue());
            }
            if (headers.containsKey("path")) {
                options = this.getListOptions(options).path(message.getHeader("path", String.class));
            }
        }
        return options;
    }

    private ContainerListOptions getListOptions(ContainerListOptions options) {
        return options == null ? ContainerListOptions.create() : options;
    }
}

