/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openstack.swift.producer;

import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.openstack.common.AbstractOpenstackProducer;
import org.apache.camel.component.openstack.common.OpenstackException;
import org.apache.camel.component.openstack.swift.SwiftEndpoint;
import org.apache.camel.util.StringHelper;
import org.openstack4j.api.OSClient;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.common.Payload;
import org.openstack4j.model.storage.object.SwiftObject;
import org.openstack4j.model.storage.object.options.ObjectListOptions;
import org.openstack4j.model.storage.object.options.ObjectLocation;

public class ObjectProducer
extends AbstractOpenstackProducer {
    public ObjectProducer(SwiftEndpoint endpoint, OSClient client) {
        super(endpoint, client);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = this.getOperation(exchange)) {
            case "create": {
                this.doCreate(exchange);
                break;
            }
            case "get": {
                this.doGet(exchange);
                break;
            }
            case "getAll": {
                this.doGetAll(exchange);
                break;
            }
            case "delete": {
                this.doDelete(exchange);
                break;
            }
            case "getMetadata": {
                this.doGetMetadata(exchange);
                break;
            }
            case "createUpdateMetadata": {
                this.doUpdateMetadata(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    private void doCreate(Exchange exchange) {
        Message msg = exchange.getIn();
        Payload payload = this.createPayload(msg);
        String containerName = msg.getHeader("containerName", String.class);
        String objectName = msg.getHeader("objectName", String.class);
        StringHelper.notEmpty(containerName, "Container name");
        StringHelper.notEmpty(objectName, "Object name");
        String etag = this.os.objectStorage().objects().put(containerName, objectName, payload);
        msg.setBody(etag);
    }

    private void doGet(Exchange exchange) {
        Message msg = exchange.getIn();
        String containerName = msg.getHeader("containerName", String.class);
        String objectName = msg.getHeader("objectName", String.class);
        StringHelper.notEmpty(containerName, "Container name");
        StringHelper.notEmpty(objectName, "Object name");
        SwiftObject out = this.os.objectStorage().objects().get(containerName, objectName);
        msg.setBody(out);
    }

    private void doGetAll(Exchange exchange) {
        List<? extends SwiftObject> out;
        Message msg = exchange.getIn();
        String name = msg.getHeader("containerName", msg.getHeader("name", String.class), String.class);
        StringHelper.notEmpty(name, "Container name");
        String path = msg.getHeader("path", String.class);
        if (path != null) {
            StringHelper.notEmpty(path, "Path");
            ObjectListOptions objectListOptions = ObjectListOptions.create();
            objectListOptions.startsWith(path).delimiter('/');
            out = this.os.objectStorage().objects().list(name, objectListOptions);
        } else {
            out = this.os.objectStorage().objects().list(name);
        }
        exchange.getIn().setBody(out);
    }

    private void doDelete(Exchange exchange) {
        Message msg = exchange.getIn();
        String containerName = msg.getHeader("containerName", String.class);
        String objectName = msg.getHeader("objectName", String.class);
        StringHelper.notEmpty(containerName, "Container name");
        StringHelper.notEmpty(objectName, "Object name");
        ActionResponse out = this.os.objectStorage().objects().delete(containerName, objectName);
        this.checkFailure(out, exchange, "Delete container");
    }

    private void doGetMetadata(Exchange exchange) {
        Message msg = exchange.getIn();
        String containerName = msg.getHeader("containerName", String.class);
        String objectName = msg.getHeader("objectName", String.class);
        StringHelper.notEmpty(containerName, "Container name");
        StringHelper.notEmpty(objectName, "Object name");
        msg.setBody(this.os.objectStorage().objects().getMetadata(containerName, objectName));
    }

    private void doUpdateMetadata(Exchange exchange) {
        Message msg = exchange.getIn();
        String containerName = msg.getHeader("containerName", String.class);
        String objectName = msg.getHeader("objectName", String.class);
        StringHelper.notEmpty(containerName, "Container name");
        StringHelper.notEmpty(objectName, "Object name");
        boolean success = this.os.objectStorage().objects().updateMetadata(ObjectLocation.create(containerName, objectName), msg.getBody(Map.class));
        if (!success) {
            exchange.setException(new OpenstackException("Updating metadata was not successful"));
        }
    }
}

