/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.compute.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.compute.QuotaSetService;
import org.openstack4j.model.compute.Limits;
import org.openstack4j.model.compute.QuotaSet;
import org.openstack4j.model.compute.QuotaSetUpdate;
import org.openstack4j.model.compute.SimpleTenantUsage;
import org.openstack4j.openstack.compute.domain.NovaLimits;
import org.openstack4j.openstack.compute.domain.NovaQuotaSet;
import org.openstack4j.openstack.compute.domain.NovaQuotaSetUpdate;
import org.openstack4j.openstack.compute.domain.NovaSimpleTenantUsage;
import org.openstack4j.openstack.compute.internal.BaseComputeServices;

public class QuotaSetServiceImpl
extends BaseComputeServices
implements QuotaSetService {
    @Override
    public QuotaSet get(String tenantId) {
        return this.get(tenantId, null);
    }

    @Override
    public QuotaSet get(String tenantId, String userId) {
        Preconditions.checkNotNull(tenantId);
        String uri = userId != null ? this.uri("/os-quota-sets/%s?user_id=%s", tenantId, userId) : this.uri("/os-quota-sets/%s", tenantId);
        return this.get(NovaQuotaSet.class, uri).execute();
    }

    @Override
    public QuotaSet updateForClass(String classId, QuotaSetUpdate qs) {
        Preconditions.checkNotNull(classId);
        Preconditions.checkNotNull(qs);
        return this.put(NovaQuotaSet.NovaQuotaSetClass.class, this.uri("/os-quota-class-sets/%s", classId)).entity(NovaQuotaSetUpdate.NovaQuotaSetUpdateClass.from(qs)).execute();
    }

    @Override
    public QuotaSet updateForTenant(String tenantId, QuotaSetUpdate qs) {
        Preconditions.checkNotNull(tenantId);
        Preconditions.checkNotNull(qs);
        return this.put(NovaQuotaSet.class, this.uri("/os-quota-sets/%s", tenantId)).entity(NovaQuotaSetUpdate.NovaQuotaSetUpdateTenant.from(qs)).execute();
    }

    @Override
    public Limits limits() {
        return this.get(NovaLimits.class, this.uri("/limits", new Object[0])).execute();
    }

    @Override
    public List<? extends SimpleTenantUsage> listTenantUsages() {
        return this.get(NovaSimpleTenantUsage.NovaSimpleTenantUsages.class, this.uri("/os-simple-tenant-usage", new Object[0])).execute().getList();
    }

    @Override
    public SimpleTenantUsage getTenantUsage(String tenantId) {
        Preconditions.checkNotNull(tenantId);
        return this.get(NovaSimpleTenantUsage.class, this.uri("/os-simple-tenant-usage/%s", tenantId)).execute();
    }

    @Override
    public List<? extends SimpleTenantUsage> listTenantUsages(String startTime, String endTime) {
        Preconditions.checkNotNull(startTime);
        Preconditions.checkNotNull(endTime);
        return this.get(NovaSimpleTenantUsage.NovaSimpleTenantUsages.class, this.uri("/os-simple-tenant-usage", new Object[0])).param("start", startTime).param("end", endTime).execute().getList();
    }

    @Override
    public SimpleTenantUsage getTenantUsage(String tenantId, String startTime, String endTime) {
        Preconditions.checkNotNull(tenantId);
        Preconditions.checkNotNull(startTime);
        Preconditions.checkNotNull(endTime);
        return this.get(NovaSimpleTenantUsage.class, this.uri("/os-simple-tenant-usage/%s", tenantId)).param("start", startTime).param("end", endTime).param("detailed", "1").execute();
    }
}

