/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.dns.v2.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.dns.v2.RecordsetService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.dns.v2.Recordset;
import org.openstack4j.openstack.dns.v2.domain.DesignateRecordset;
import org.openstack4j.openstack.dns.v2.internal.BaseDNSServices;

public class RecordsetServiceImpl
extends BaseDNSServices
implements RecordsetService {
    @Override
    public Recordset get(String zoneId, String recordsetId) {
        Preconditions.checkNotNull(zoneId);
        Preconditions.checkNotNull(recordsetId);
        return this.get(DesignateRecordset.class, "/zones", "/", zoneId, "/recordsets", "/", recordsetId).execute();
    }

    @Override
    public ActionResponse delete(String zoneId, String recordsetId) {
        Preconditions.checkNotNull(zoneId);
        Preconditions.checkNotNull(recordsetId);
        return this.deleteWithResponse("/zones", "/", zoneId, "/recordsets", "/", recordsetId).execute();
    }

    @Override
    public Recordset update(String zoneId, Recordset recordset) {
        Preconditions.checkNotNull(zoneId);
        Preconditions.checkNotNull(recordset);
        return this.put(DesignateRecordset.class, "/zones", "/", zoneId, "/recordsets", "/", recordset.getId()).entity(recordset).execute();
    }

    @Override
    public Recordset create(String zoneId, Recordset recordset) {
        Preconditions.checkNotNull(zoneId);
        Preconditions.checkNotNull(recordset);
        return this.post(DesignateRecordset.class, "/zones", "/", zoneId, "/recordsets").entity(recordset).execute();
    }

    @Override
    public Recordset create(String zoneId, String name, String type, List<String> records) {
        Preconditions.checkNotNull(zoneId);
        Preconditions.checkNotNull(name);
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull(records);
        return this.create(zoneId, (Recordset)DesignateRecordset.builder().name(name).type(type).records(records).build());
    }

    @Override
    public List<? extends Recordset> list(String zoneId) {
        Preconditions.checkNotNull(zoneId);
        return this.get(DesignateRecordset.Recordsets.class, "/zones", "/", zoneId, "/recordsets").execute().getList();
    }

    @Override
    public List<? extends Recordset> list() {
        return this.get(DesignateRecordset.Recordsets.class, this.uri("/recordsets", new Object[0])).execute().getList();
    }
}

