/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.gbp.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.List;
import org.openstack4j.model.gbp.ExternalRoutes;
import org.openstack4j.model.gbp.ExternalSegment;
import org.openstack4j.model.gbp.builder.ExternalSegmentBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.gbp.domain.GbpExternalRoutes;

@JsonRootName(value="external_segment")
public class GbpExternalSegment
implements ExternalSegment {
    private static final long serialVersionUID = 1L;
    private String name;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    private String id;
    @JsonProperty(value="external_policies")
    private List<String> externalPolicies;
    @JsonProperty(value="l3_policies")
    private List<String> l3Policies;
    @JsonProperty(value="nat_pools")
    private List<String> natpools;
    @JsonProperty(value="ip_version")
    private int ipVersion;
    @JsonProperty(value="cidr")
    private String cidr;
    private String description;
    private Boolean shared;
    @JsonProperty(value="subnet_id")
    private String subnetId;
    @JsonProperty(value="port_address_translation")
    private boolean portAddressTranslation;
    @JsonProperty(value="external_routes")
    private List<GbpExternalRoutes> externalRoutes;

    public static ExternalSegmentBuilder builder() {
        return new ExternalSegmentConcreteBuilder();
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public List<String> getExternalPolicies() {
        return this.externalPolicies;
    }

    @Override
    public int getIpVersion() {
        return this.ipVersion;
    }

    @Override
    public String getCidr() {
        return this.cidr;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isShared() {
        return this.shared == null ? false : this.shared;
    }

    @Override
    public String getSubnetId() {
        return this.subnetId;
    }

    @Override
    public List<String> getL3Policies() {
        return this.l3Policies;
    }

    @Override
    public List<String> getNatpools() {
        return this.natpools;
    }

    @Override
    public boolean isPortAddressTranslation() {
        return this.portAddressTranslation;
    }

    @Override
    public List<GbpExternalRoutes> getExternalRoutes() {
        return this.externalRoutes;
    }

    @Override
    public ExternalSegmentBuilder toBuilder() {
        return new ExternalSegmentConcreteBuilder(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("id", this.id).add("name", this.name).add("desription", this.description).add("tenantId", this.tenantId).add("externalPolicies", this.externalPolicies).add("l3Policies", this.l3Policies).add("natpools", this.natpools).add("ipVersion", this.ipVersion).add("cidr", this.cidr).add("shared", this.shared).add("subnetId", this.subnetId).add("portAddressTranslation", this.portAddressTranslation).add("externalRoutes", this.externalRoutes).toString();
    }

    public static class ExternalSegmentConcreteBuilder
    implements ExternalSegmentBuilder {
        private GbpExternalSegment extSegment;

        public ExternalSegmentConcreteBuilder() {
            this(new GbpExternalSegment());
        }

        public ExternalSegmentConcreteBuilder(GbpExternalSegment gbpExternalSegment) {
            this.extSegment = gbpExternalSegment;
        }

        @Override
        public ExternalSegment build() {
            return this.extSegment;
        }

        @Override
        public ExternalSegmentBuilder from(ExternalSegment in) {
            this.extSegment = (GbpExternalSegment)in;
            return this;
        }

        @Override
        public ExternalSegmentBuilder name(String name) {
            this.extSegment.name = name;
            return this;
        }

        @Override
        public ExternalSegmentBuilder description(String description) {
            this.extSegment.description = description;
            return this;
        }

        @Override
        public ExternalSegmentBuilder externalPolicies(List<String> extPolicyIds) {
            this.extSegment.externalPolicies = extPolicyIds;
            return this;
        }

        @Override
        public ExternalSegmentBuilder ipVersion(int ipVersion) {
            this.extSegment.ipVersion = ipVersion;
            return this;
        }

        @Override
        public ExternalSegmentBuilder cidr(String cidr) {
            this.extSegment.cidr = cidr;
            return this;
        }

        @Override
        public ExternalSegmentBuilder isShared(boolean shared) {
            this.extSegment.shared = shared;
            return this;
        }

        @Override
        public ExternalSegmentBuilder externalRoutes(List<ExternalRoutes> extRoutes) {
            this.extSegment.externalRoutes = Lists.newArrayList();
            for (ExternalRoutes externalRoute : extRoutes) {
                this.extSegment.externalRoutes.add((GbpExternalRoutes)externalRoute);
            }
            return this;
        }

        @Override
        public ExternalSegmentBuilder subnetId(String subnetId) {
            this.extSegment.subnetId = subnetId;
            return this;
        }

        @Override
        public ExternalSegmentBuilder isPortAddressTranslation(boolean isPortAddressTranslation) {
            this.extSegment.portAddressTranslation = isPortAddressTranslation;
            return this;
        }
    }

    public static class ExternalSegments
    extends ListResult<GbpExternalSegment> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="external_segments")
        private List<GbpExternalSegment> externalSegments;

        @Override
        public List<GbpExternalSegment> value() {
            return this.externalSegments;
        }
    }
}

