/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.heat.internal;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.openstack4j.api.Builders;
import org.openstack4j.api.heat.TemplateService;
import org.openstack4j.model.heat.Template;
import org.openstack4j.model.heat.TemplateResponse;
import org.openstack4j.openstack.heat.internal.BaseHeatServices;

public class TemplateServiceImpl
extends BaseHeatServices
implements TemplateService {
    @Override
    public TemplateResponse validateTemplate(String template) {
        Preconditions.checkNotNull(template);
        return this.validateTemplate((Template)Builders.template().templateJson(template).build());
    }

    @Override
    public TemplateResponse validateTemplateByURL(String templateURL) {
        Preconditions.checkNotNull(templateURL);
        return this.validateTemplate((Template)Builders.template().templateURL(templateURL).build());
    }

    @Override
    public TemplateResponse validateTemplate(Template template) {
        Preconditions.checkNotNull(template);
        try {
            this.post(String.class, this.uri("/validate", new Object[0])).entity(template).execute();
        }
        catch (RuntimeException re) {
            return TemplateResponse.fail(re.getMessage());
        }
        return TemplateResponse.success();
    }

    @Override
    public String getTemplateAsString(String stackName, String stackId) {
        Preconditions.checkNotNull(stackName);
        Preconditions.checkNotNull(stackId);
        return this.get(String.class, this.uri("/stacks/%s/%s/template", stackName, stackId)).execute();
    }

    @Override
    public Map<String, Object> getTemplateAsMap(String stackName, String stackId) {
        Preconditions.checkNotNull(stackName);
        Preconditions.checkNotNull(stackId);
        return this.get(Map.class, this.uri("/stacks/%s/%s/template", stackName, stackId)).execute();
    }

    @Override
    public Map<String, Object> getTemplateAsMap(String stackNameOrId) {
        Preconditions.checkNotNull(stackNameOrId);
        return this.get(Map.class, this.uri("/stacks/%s/template", stackNameOrId)).execute();
    }
}

